/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.client.feignimpl.member;

import com.enation.app.javashop.client.member.ShopClient;
import com.enation.app.javashop.core.client.hystrix.member.ShopClientFallback;
import com.enation.app.javashop.model.shop.dos.ShopDO;
import com.enation.app.javashop.model.shop.dos.Store;
import com.enation.app.javashop.model.shop.dto.ShopBankDTO;
import com.enation.app.javashop.model.shop.vo.ShopVO;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="nrmember-app", fallback=ShopClientFallback.class)
public interface ShopClientFeigntImpl
extends ShopClient {
    @RequestMapping(value={"/client/shops/template"}, method={RequestMethod.GET})
    public ShopVO checkShipTemplate(@RequestParam(value="template_id") Long var1);

    @RequestMapping(value={"/client/shops/{shop_id}"}, method={RequestMethod.GET})
    public ShopVO getShop(@PathVariable(value="shop_id") Long var1);

    @RequestMapping(value={"/client/shops/bank-info"}, method={RequestMethod.GET})
    public List<ShopBankDTO> listShopBankInfo();

    @RequestMapping(value={"/client/shops/collection/{shop_id}"}, method={RequestMethod.POST})
    public void addCollectNum(@PathVariable(value="shop_id") Long var1);

    @RequestMapping(value={"/client/shops/{shop_id}/collection"}, method={RequestMethod.POST})
    public void reduceCollectNum(@PathVariable(value="shop_id") Long var1);

    @RequestMapping(value={"/client/shops/calculate-shop-score"}, method={RequestMethod.GET})
    public void calculateShopScore();

    @RequestMapping(value={"/client/shops/{seller_id}/shop-goods-num"}, method={RequestMethod.POST})
    public void updateShopGoodsNum(@PathVariable(value="seller_id") Long var1, @RequestParam(value="seller_goods_count") Integer var2);

    @GetMapping(value={"/client/shops/store"})
    public Store getStore(@RequestParam(value="store_id") Long var1);

    @RequestMapping(value={"/client/shops/{shop_id}/shop"}, method={RequestMethod.PUT})
    public ShopDO editShop(@PathVariable(value="shop_id") Long var1, @RequestBody ShopDO var2);

    @RequestMapping(value={"/client/shops/{shop_id}/shop"}, method={RequestMethod.GET})
    public ShopDO getShopDO(@PathVariable(value="shop_id") Long var1);
}

