/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.weixin.executor;

import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.aftersale.enums.RefundStatusEnum;
import com.enation.app.javashop.model.payment.vo.RefundBill;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPayConfig;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPuginConfig;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinUtil;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeixinRefundExecutor
extends WeixinPuginConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Cache cache;

    public boolean returnPay(RefundBill bill) {
        WeixinPayConfig config = this.getConfig(bill.getConfigMap());
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appid", config.getAppId());
        params.put("mch_id", config.getMchId());
        params.put("nonce_str", StringUtil.getRandStr((int)10));
        params.put("transaction_id", bill.getReturnTradeNo());
        params.put("refund_fee", CurrencyUtil.toFen((Double)bill.getRefundPrice()));
        params.put("total_fee", CurrencyUtil.toFen((Double)bill.getTradePrice()));
        params.put("out_refund_no", bill.getRefundSn());
        String sign = WeixinUtil.createSign(params, (String)config.getKey());
        params.put("sign", sign);
        try {
            String xml = WeixinUtil.mapToXml(params);
            File file = new File(config.getP12Path());
            if (!file.exists()) {
                this.cache.put((Object)("{REFUND_ERROR_MESSAGE}_" + bill.getRefundSn()), (Object)("\u627e\u4e0d\u5230\u8bc1\u4e66\u8def\u5f84" + config.getP12Path() + "\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6b63\u786e\u914d\u7f6e"));
                return false;
            }
            Document resultDoc = WeixinUtil.verifyCertPost((String)"https://api.mch.weixin.qq.com/secapi/pay/refund", (String)xml, (String)config.getMchId(), (String)config.getP12Path());
            Element rootEl = resultDoc.getRootElement();
            String returnCode = rootEl.element("return_code").getText();
            if ("SUCCESS".equals(returnCode)) {
                String resultCode = rootEl.element("result_code").getText();
                if ("SUCCESS".equals(resultCode)) {
                    return true;
                }
                String errCode = rootEl.element("err_code").getText();
                String errCodeDes = rootEl.element("err_code_des").getText();
                String failReason = "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5e76\u63d0\u4f9b\u9000\u6b3e\u9519\u8bef\u4fe1\u606f\uff1a" + errCode + "," + errCodeDes;
                this.cache.put((Object)("{REFUND_ERROR_MESSAGE}_" + bill.getRefundSn()), (Object)failReason);
                return false;
            }
            String failReason = "\u539f\u8def\u9000\u56de\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u53c2\u6570\u914d\u7f6e";
            Element returnMsg = rootEl.element("return_msg");
            if (returnMsg != null) {
                failReason = "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5e76\u63d0\u4f9b\u9000\u6b3e\u9519\u8bef\u4fe1\u606f\uff1a" + returnMsg.getText();
            }
            this.cache.put((Object)("{REFUND_ERROR_MESSAGE}_" + bill.getRefundSn()), (Object)failReason);
            return false;
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25", (Throwable)e);
            this.cache.put((Object)("{REFUND_ERROR_MESSAGE}_" + bill.getRefundSn()), (Object)"\u5f02\u5e38");
            e.printStackTrace();
            return false;
        }
    }

    public String queryRefundStatus(RefundBill bill) {
        WeixinPayConfig config = this.getConfig(bill.getConfigMap());
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appid", config.getAppId());
        params.put("mch_id", config.getMchId());
        params.put("nonce_str", StringUtil.getRandStr((int)10));
        params.put("out_refund_no", bill.getRefundSn());
        String sign = WeixinUtil.createSign(params, (String)config.getKey());
        params.put("sign", sign);
        try {
            String xml = WeixinUtil.mapToXml(params);
            Document resultDoc = WeixinUtil.post((String)"https://api.mch.weixin.qq.com/pay/refundquery", (String)xml);
            Map resultMap = WeixinUtil.xmlToMap((Document)resultDoc);
            if ("SUCCESS".equals(resultMap.get("return_code"))) {
                String status = (String)resultMap.get("refund_status_0");
                if ("SUCCESS".equals(status)) {
                    return RefundStatusEnum.COMPLETED.value();
                }
                if ("PROCESSING".equals(status)) {
                    return RefundStatusEnum.REFUNDING.value();
                }
                return RefundStatusEnum.REFUNDFAIL.value();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return RefundStatusEnum.REFUNDING.value();
    }

    private WeixinPayConfig getConfig(Map<String, String> config) {
        WeixinPayConfig weixinPayConfig = new WeixinPayConfig();
        weixinPayConfig.setAppId(config.get("appid"));
        weixinPayConfig.setMchId(config.get("mchid"));
        weixinPayConfig.setKey(config.get("key"));
        weixinPayConfig.setP12Path(config.get("p12_path"));
        return weixinPayConfig;
    }
}

