/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.weixin.executor;

import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.model.base.DomainHelper;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPuginConfig;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeixinPaymentWapExecutor
extends WeixinPuginConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DomainHelper domainHelper;

    public Map onPay(PayBill bill) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        TreeMap<String, String> result = new TreeMap<String, String>();
        params.put("spbill_create_ip", this.getIpAddress());
        params.put("trade_type", "MWEB");
        try {
            Map map = super.createUnifiedOrder(bill, params);
            String resultCode = (String)map.get("result_code");
            if ("SUCCESS".equals(resultCode)) {
                String codeUrl = (String)map.get("mweb_url");
                result.put("gateway_url", codeUrl + "&redirect_url=" + this.getPayWapSuccessUrl(bill.getTradeType().name(), bill.getSubSn()));
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u53c2\u6570\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private String getPayWapSuccessUrl(String tradeType, String subSn) {
        StringBuffer url = new StringBuffer(this.domainHelper.getMobileDomain() + "/checkout/cashier?");
        if (TradeTypeEnum.TRADE.name().equals(tradeType)) {
            url.append("trade_sn=" + subSn);
        } else {
            url.append("order_sn=" + subSn);
        }
        return url.toString();
    }
}

