/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.weixin.executor;

import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.context.user.UserContext;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.security.model.Buyer;
import com.enation.app.javashop.framework.util.DateUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.CachePrefix;
import com.enation.app.javashop.model.member.vo.Auth2Token;
import com.enation.app.javashop.model.payment.vo.FormItem;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPuginConfig;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeixinPaymentJsapiExecutor
extends WeixinPuginConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Cache cache;

    public Map onPay(PayBill bill) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        TreeMap<String, String> resultMap = new TreeMap<String, String>();
        params.put("spbill_create_ip", "0:0:0:0:0:0:0:1");
        params.put("trade_type", "JSAPI");
        Buyer buyer = UserContext.getBuyer();
        Auth2Token token = (Auth2Token)this.cache.get((Object)(CachePrefix.CONNECT_LOGIN.getPrefix() + buyer.getUuid()));
        String openid = token.getOpneId();
        params.put("openid", openid);
        String result = "";
        try {
            Map map = super.createUnifiedOrder(bill, params);
            String returnCode = (String)map.get("return_code");
            this.logger.debug("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\u7ed3\u679c\uff1a" + returnCode);
            if ("SUCCESS".equals(returnCode)) {
                String resultCode = (String)map.get("result_code");
                if ("SUCCESS".equals(resultCode)) {
                    String prepayId = (String)map.get("prepay_id");
                    this.logger.debug("\u5fae\u4fe1\u652f\u4ed8id\uff1a" + prepayId);
                    TreeMap weixinparams = new TreeMap();
                    weixinparams.put("appId", map.get("appid"));
                    weixinparams.put("nonceStr", StringUtil.getRandStr((int)10));
                    weixinparams.put("timeStamp", String.valueOf(DateUtil.getDateline()));
                    weixinparams.put("package", "prepay_id=" + prepayId);
                    weixinparams.put("signType", "MD5");
                    String sign = WeixinUtil.createSign(weixinparams, (String)((String)map.get("key")));
                    weixinparams.put("paySign", sign);
                    resultMap = weixinparams;
                    String outTradeNo = bill.getBillSn();
                    this.logger.debug("\u5fae\u4fe1\u8fd4\u56demap\uff1a" + weixinparams);
                    result = this.getPayScript(prepayId, (String)map.get("appid"), (String)map.get("key"), outTradeNo, bill.getTradeType());
                    this.logger.debug("\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
                } else {
                    String errCode = (String)map.get("err_code");
                    String errCodeDes = (String)map.get("err_code_des");
                    result = "<script>alert('\u652f\u4ed8\u610f\u5916\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458:" + errCode + "\u3010" + errCodeDes + "\u3011')</script>";
                    this.logger.error(result);
                }
            } else {
                result = "<script>alert('\u652f\u4ed8\u610f\u5916\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458:" + returnCode + "')</script>";
                if ("FAIL".equals(returnCode)) {
                    String returnMsg = (String)map.get("return_msg");
                    this.logger.error("\u5fae\u4fe1\u7aef\u8fd4\u56de\u9519\u8bef" + returnCode + "[" + returnMsg + "]");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u751f\u6210\u652f\u4ed8\u4e8c\u7ef4\u7801\u9519\u8bef", (Throwable)e);
            return null;
        }
        resultMap.put("gateway_url", result);
        return resultMap;
    }

    private List<FormItem> getItems(Map<String, String> weixinparams) {
        ArrayList<FormItem> items = new ArrayList<FormItem>();
        for (String key : weixinparams.keySet()) {
            FormItem item = new FormItem();
            item.setItemName(key);
            item.setItemValue(weixinparams.get(key));
            items.add(item);
        }
        return items;
    }

    private String getPayWapSuccessUrl(String tradeType, String outTradeNo) {
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        String serverName = request.getServerName();
        int port = request.getServerPort();
        String portstr = "";
        if (port != 80) {
            portstr = ":" + port;
        }
        String contextPath = request.getContextPath();
        this.logger.info("\u652f\u4ed8\u6210\u529f\u9875\u9762\u8df3\u8f6c\uff1ahttp://" + serverName + portstr + contextPath + "/" + tradeType + "_" + outTradeNo + "_payment-wap-result.html");
        return "http://" + serverName + portstr + contextPath + "/" + tradeType + "_" + outTradeNo + "_payment-wap-result.html";
    }

    private String getPayScript(String prepayId, String appid, String weixinkey, String outTradeNo, TradeTypeEnum tradeType) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appId", appid);
        params.put("nonceStr", StringUtil.getRandStr((int)10));
        params.put("timestamp", String.valueOf(DateUtil.getDateline()));
        params.put("package", "prepay_id=" + prepayId);
        params.put("signType", "MD5");
        String sign = WeixinUtil.createSign(params, (String)weixinkey);
        params.put("paySign", sign);
        StringBuffer payStr = new StringBuffer();
        payStr.append("WeixinJSBridge.invoke('getBrandWCPayRequest',{");
        int i = 0;
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            if (i != 0) {
                payStr.append(",");
            }
            payStr.append("'" + key + "':'" + value + "'");
            ++i;
        }
        payStr.append("}");
        payStr.append(",function(res){  if( 'get_brand_wcpay_request:ok'==res.err_msg ) { alert('\u652f\u4ed8\u6210\u529f'); location.href='" + this.getPayWapSuccessUrl(tradeType.name(), outTradeNo) + "?operation=success';" + "}else{ alert('\u652f\u4ed8\u5931\u8d25'); " + "location.href='" + this.getPayWapSuccessUrl(tradeType.name(), outTradeNo) + "?operation=fail';" + "} " + "}");
        payStr.append(");");
        return payStr.toString();
    }
}

