/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.weixin.executor;

import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.DomainHelper;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.service.payment.PaymentManager;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPuginConfig;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeixinPaymentExecutor
extends WeixinPuginConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Cache cache;
    @Autowired
    private DomainHelper domainHelper;
    @Autowired
    private Debugger debugger;
    @Autowired
    private PaymentManager paymentManager;

    public Map onPay(PayBill bill) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        TreeMap<String, String> result = new TreeMap<String, String>();
        params.put("spbill_create_ip", "127.0.0.1");
        params.put("trade_type", "NATIVE");
        try {
            Map map = super.createUnifiedOrder(bill, params);
            String resultCode = (String)map.get("result_code");
            if ("SUCCESS".equals(resultCode)) {
                this.debugger.log("\u521b\u5efa\u9884\u4ed8\u8ba2\u5355\u6210\u529f");
                this.logger.debug("\u521b\u5efa\u9884\u4ed8\u8ba2\u5355\u6210\u529f");
                String codeUrl = (String)map.get("code_url");
                String qr = codeUrl.replaceAll("weixin://wxpay/bizpayurl[?]pr=", "");
                String outTradeNo = bill.getBillSn();
                String gateWay = this.domainHelper.getCallback() + "/payment/weixin/qr/" + qr + "";
                this.debugger.log("\u751f\u6210gateway:");
                this.debugger.log(gateWay);
                result.put("bill_sn", outTradeNo);
                result.put("gateway_url", gateWay);
                return result;
            }
            this.logger.debug("\u521b\u5efa\u9884\u4ed8\u8ba2\u5355\u5931\u8d25:" + JsonUtil.objectToJson((Object)map));
            this.debugger.log("\u521b\u5efa\u9884\u4ed8\u8ba2\u5355\u5931\u8d25");
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u751f\u6210\u652f\u4ed8\u4e8c\u7ef4\u7801\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    public String onCallback(ClientType clientType) {
        Map cfgparams = this.getConfig(clientType);
        String key = (String)cfgparams.get("key");
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        HashMap<String, String> map = new HashMap<String, String>(16);
        try {
            SAXReader saxReadr = new SAXReader();
            saxReadr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxReadr.read((InputStream)request.getInputStream());
            Map params = WeixinUtil.xmlToMap((Document)document);
            this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03----->" + JsonUtil.objectToJson((Object)params));
            String returnCode = (String)params.get("return_code");
            String resultCode = (String)params.get("result_code");
            if ("SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode)) {
                String sign = WeixinUtil.createSign((Map)params, (String)key);
                if (sign.equals(params.get("sign"))) {
                    String outTradeNo = (String)params.get("out_trade_no");
                    String returnTradeNo = (String)params.get("transaction_id");
                    double payPrice = StringUtil.toDouble((String)((String)params.get("total_fee")), (Double)0.0);
                    payPrice = CurrencyUtil.mul((double)payPrice, (double)0.01);
                    this.logger.info("\u652f\u4ed8\u6210\u529f:outTradeNo/returnTradeNo----->" + outTradeNo + "/" + returnTradeNo);
                    this.paySuccess(outTradeNo, returnTradeNo, payPrice);
                    map.put("return_code", "SUCCESS");
                    this.cache.put((Object)("{pay}_" + outTradeNo), (Object)"ok", 120);
                } else {
                    map.put("return_code", "FAIL");
                    map.put("return_msg", "\u7b7e\u540d\u5931\u8d25");
                    this.logger.error("\u5fae\u4fe1\u7b7e\u540d\u5931\u8d25");
                }
            } else {
                map.put("return_code", "FAIL");
                this.logger.error("\u5fae\u4fe1\u9a8c\u7b7e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            map.put("return_code", "FAIL");
            map.put("return_msg", "");
            this.logger.error("\u5fae\u4fe1\u901a\u77e5\u7684\u7ed3\u679c\u4e3a\u5931\u8d25", (Throwable)e);
        }
        HttpServletResponse response = ThreadContextHolder.getHttpResponse();
        response.setHeader("Content-Type", "text/xml");
        try {
            return WeixinUtil.mapToXml(map);
        }
        catch (Exception e) {
            this.logger.error("\u5fae\u4fe1\u901a\u77e5\u7684\u7ed3\u679c\u4e3a\u5931\u8d25", (Throwable)e);
            return "\u51fa\u73b0\u9519\u8bef";
        }
    }

    public String onQuery(String billSn, Map<String, String> config) {
        if (config == null) {
            config = this.getConfig(ClientType.PC);
        }
        String appId = config.get("appid");
        String mchId = (String)config.get("mchid");
        String key = (String)config.get("key");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appid", appId);
        params.put("mch_id", mchId);
        params.put("nonce_str", StringUtil.getRandStr((int)10));
        params.put("out_trade_no", billSn);
        String sign = WeixinUtil.createSign(params, (String)key);
        params.put("sign", sign);
        try {
            String xml = WeixinUtil.mapToXml(params);
            Document resultDoc = WeixinUtil.post((String)"https://api.mch.weixin.qq.com/pay/orderquery", (String)xml);
            Map returnParams = WeixinUtil.xmlToMap((Document)resultDoc);
            String returnCode = (String)returnParams.get("return_code");
            String resultCode = (String)returnParams.get("result_code");
            String tradeState = (String)returnParams.get("trade_state");
            if ("SUCCESS".equals(returnCode) || "SUCCESS".equals(resultCode)) {
                if ("SUCCESS".equals(tradeState)) {
                    return "SUCCESS";
                }
                return "FAIL";
            }
            return "FAIL";
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5fae\u4fe1\u652f\u4ed8\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            return "FAIL";
        }
    }
}

