/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.weixin.executor;

import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.DateUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPuginConfig;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinUtil;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.stereotype.Service;

@Service
public class WeixinPaymentAppExecutor
extends WeixinPuginConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Map onPay(PayBill bill) {
        try {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("spbill_create_ip", this.getIpAddress());
            params.put("trade_type", "APP");
            Map map = super.createUnifiedOrder(bill, params);
            String resultCode = (String)map.get("result_code");
            String retureCode = (String)map.get("return_code");
            if ("FAIL".equals(retureCode)) {
                this.logger.error((String)map.get("return_msg"));
            }
            if ("SUCCESS".equals(resultCode)) {
                String prepayId = (String)map.get("prepay_id");
                TreeMap result = new TreeMap();
                result.put("appid", map.get("appid"));
                result.put("partnerid", map.get("mchid"));
                result.put("prepayid", prepayId);
                result.put("package", "Sign=WXPay");
                result.put("noncestr", StringUtil.getRandStr((int)10));
                result.put("timestamp", DateUtil.getDateline() + "");
                result.put("sign", WeixinUtil.createSign(result, (String)((String)map.get("key"))));
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u8fd4\u56de\u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        return null;
    }
}

