/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.weixin;

import com.enation.app.javashop.client.system.SettingClient;
import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.SettingGroup;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.system.vo.SiteSetting;
import com.enation.app.javashop.service.payment.AbstractPaymentPlugin;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinPayConfig;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;

public class WeixinPuginConfig
extends AbstractPaymentPlugin {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String OPENID_SESSION_KEY = "weixin_openid";
    public static final String UNIONID_SESSION_KEY = "weixin_unionid";
    public static final String QR_URL_PREFIX = "weixin://wxpay/bizpayurl[?]pr=";
    public static final String CACHE_KEY_PREFIX = "{pay}_";
    @Autowired
    private SettingClient settingClient;

    protected String getPluginId() {
        return "weixinPayPlugin";
    }

    protected Map<String, String> createUnifiedOrder(PayBill bill, Map<String, String> params) {
        Map map = this.getConfig(bill.getClientType());
        WeixinPayConfig config = new WeixinPayConfig();
        config.setAppId((String)map.get("appid"));
        config.setMchId((String)map.get("mchid"));
        config.setKey((String)map.get("key"));
        params.put("appid", config.getAppId());
        params.put("mch_id", config.getMchId());
        params.put("nonce_str", StringUtil.getRandStr((int)10));
        params.put("body", this.getSiteName() + "-" + bill.getSubSn());
        params.put("out_trade_no", bill.getBillSn());
        Double money = bill.getOrderPrice();
        if (money != null) {
            params.put("total_fee", CurrencyUtil.toFen((Double)money));
        }
        params.put("notify_url", this.getCallBackUrl(bill.getTradeType(), bill.getClientType()));
        this.logger.info("\u5fae\u4fe1\u56de\u8c03\u5730\u5740\uff1a" + this.getCallBackUrl(bill.getTradeType(), bill.getClientType()));
        String sign = WeixinUtil.createSign(params, (String)config.getKey());
        params.put("sign", sign);
        try {
            String xml = WeixinUtil.mapToXml(params);
            this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\u5982\u4e0b\uff1a");
            this.logger.info(xml);
            Document resultDoc = WeixinUtil.post((String)"https://api.mch.weixin.qq.com/pay/unifiedorder", (String)xml);
            Map resultMap = WeixinUtil.xmlToMap((Document)resultDoc);
            resultMap.putAll(map);
            return resultMap;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    protected String getIpAddress() {
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtil.isEmpty((String)ip)) {
            return request.getRemoteAddr();
        }
        if (ip.contains(",")) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    protected String getSiteName() {
        String siteSettingJson = this.settingClient.get(SettingGroup.SITE);
        SiteSetting siteSetting = (SiteSetting)JsonUtil.jsonToObject((String)siteSettingJson, SiteSetting.class);
        return siteSetting.getSiteName();
    }
}

