/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.unionpay.sdk;

import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.CertUtil;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.LogUtil;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.SDKConfig;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.SDKUtil;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.SecureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class CertUtil {
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static PublicKey encryptTrackKey = null;
    private static X509Certificate validateCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap();
    private static final ThreadLocal<KeyStore> KEY_STORE_THREAD_LOCAL = new ThreadLocal();
    private static final Map<String, KeyStore> STRING_KEY_STORE_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    private static void addProvider() {
        if (Security.getProvider("BC") == null) {
            LogUtil.writeLog((String)"add BC provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            LogUtil.writeLog((String)"re-add BC provider");
        }
        CertUtil.printSysInfo();
    }

    public static void init() {
        CertUtil.addProvider();
        if ("true".equals(SDKConfig.getConfig().getSingleMode())) {
            CertUtil.initSignCert();
        }
        CertUtil.initEncryptCert();
        CertUtil.initTrackKey();
        CertUtil.initValidateCertFromDir();
    }

    public static void initSignCert() {
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo((String)SDKConfig.getConfig().getSignCertPath(), (String)SDKConfig.getConfig().getSignCertPwd(), (String)SDKConfig.getConfig().getSignCertType());
            LogUtil.writeLog((String)("InitSignCert Successful. CertId=[" + CertUtil.getSignCertId() + "]"));
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)"InitSignCert Error", (Throwable)e);
        }
    }

    public static void initSignCert(String certFilePath, String certPwd) {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb."));
        KEY_STORE_THREAD_LOCAL.remove();
        File files = new File(certFilePath);
        if (!files.exists()) {
            LogUtil.writeLog((String)"\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728,\u521d\u59cb\u5316\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25.");
            return;
        }
        try {
            KEY_STORE_THREAD_LOCAL.set(CertUtil.getKeyInfo((String)certFilePath, (String)certPwd, (String)"PKCS12"));
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)"\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        LogUtil.writeLog((String)("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f."));
    }

    public static void loadRsaCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtil.getKeyInfo((String)certFilePath, (String)certPwd, (String)"PKCS12");
            STRING_KEY_STORE_CONCURRENT_HASH_MAP.put(certFilePath, keyStore);
            LogUtil.writeLog((String)"LoadRsaCert Successful");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)"LoadRsaCert Error", (Throwable)e);
        }
    }

    private static void initEncryptCert() {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u8bc1\u4e66==>" + SDKConfig.getConfig().getEncryptCertPath()));
        if (!SDKUtil.isEmpty((String)SDKConfig.getConfig().getEncryptCertPath())) {
            encryptCert = CertUtil.initCert((String)SDKConfig.getConfig().getEncryptCertPath());
            LogUtil.writeLog((String)"LoadEncryptCert Successful");
        } else {
            LogUtil.writeLog((String)"WARN: acpsdk.encryptCert.path is empty");
        }
    }

    private static void initTrackKey() {
        if (!SDKUtil.isEmpty((String)SDKConfig.getConfig().getEncryptTrackKeyModulus()) && !SDKUtil.isEmpty((String)SDKConfig.getConfig().getEncryptTrackKeyExponent())) {
            encryptTrackKey = SecureUtil.getPublicKey((String)SDKConfig.getConfig().getEncryptTrackKeyModulus(), (String)SDKConfig.getConfig().getEncryptTrackKeyExponent());
            LogUtil.writeLog((String)"LoadEncryptTrackKey Successful");
        } else {
            LogUtil.writeLog((String)"WARN: acpsdk.encryptTrackKey.modulus or acpsdk.encryptTrackKey.exponent is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            in = new FileInputStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            LogUtil.writeLog((String)("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]"));
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog((String)"InitCert Error", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog((String)"InitCert Error File Not Found", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error No BC Provider", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog((String)e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        certMap.clear();
        String dir = SDKConfig.getConfig().getValidateCertDir();
        LogUtil.writeLog((String)("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u76ee\u5f55==>" + dir));
        if (SDKUtil.isEmpty((String)dir)) {
            LogUtil.writeLog((String)"ERROR: acpsdk.validateCert.dir is empty");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            File fileDir = new File(dir);
            File[] files = fileDir.listFiles((FilenameFilter)new CerFilter());
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LogUtil.writeLog((String)("[" + file.getAbsolutePath() + "][CertId=" + validateCert.getSerialNumber().toString() + "]"));
            }
            LogUtil.writeLog((String)"LoadVerifyCert Successful");
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error File Not Found", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LogUtil.writeErrorLog((String)"LoadVerifyCert Error No BC Provider", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog((String)e.toString());
                }
            }
        }
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, SDKConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByThreadLocal(String certPath, String certPwd) {
        if (null == KEY_STORE_THREAD_LOCAL.get()) {
            CertUtil.initSignCert((String)certPath, (String)certPwd);
        }
        try {
            Enumeration<String> aliasenum = ((KeyStore)KEY_STORE_THREAD_LOCAL.get()).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)((KeyStore)KEY_STORE_THREAD_LOCAL.get()).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)("\u83b7\u53d6[" + certPath + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!STRING_KEY_STORE_CONCURRENT_HASH_MAP.containsKey(certPath)) {
            CertUtil.loadRsaCert((String)certPath, (String)certPwd);
        }
        try {
            Enumeration<String> aliasenum = ((KeyStore)STRING_KEY_STORE_CONCURRENT_HASH_MAP.get(certPath)).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)((KeyStore)STRING_KEY_STORE_CONCURRENT_HASH_MAP.get(certPath)).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog((String)"getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        if (null == encryptCert) {
            String path = SDKConfig.getConfig().getEncryptCertPath();
            if (!SDKUtil.isEmpty((String)path)) {
                encryptCert = CertUtil.initCert((String)path);
                return encryptCert.getPublicKey();
            }
            LogUtil.writeLog((String)"ERROR: acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getPublicKey();
    }

    public static PublicKey getEncryptTrackPublicKey() {
        if (null == encryptTrackKey) {
            CertUtil.initTrackKey();
        }
        return encryptTrackKey;
    }

    public static PublicKey getValidateKey() {
        if (null == validateCert) {
            return null;
        }
        return validateCert.getPublicKey();
    }

    public static PublicKey getValidateKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = (X509Certificate)certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = (X509Certificate)certMap.get(certId);
            return cf.getPublicKey();
        }
        LogUtil.writeErrorLog((String)("\u7f3a\u5c11certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66."));
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"getSignCertId Error", (Throwable)e);
            return null;
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            String path = SDKConfig.getConfig().getEncryptCertPath();
            if (!SDKUtil.isEmpty((String)path)) {
                encryptCert = CertUtil.initCert((String)path);
                return encryptCert.getSerialNumber().toString();
            }
            LogUtil.writeLog((String)"ERROR: acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getSerialNumber().toString();
    }

    public static String getEncryptTrackCertId() {
        return "";
    }

    public static PublicKey getSignPublicKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            Certificate cert = keyStore.getCertificate(keyAlias);
            PublicKey pubkey = cert.getPublicKey();
            return pubkey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        LogUtil.writeLog((String)("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile));
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance(type, "BC");
            LogUtil.writeLog((String)("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]"));
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            if (Security.getProvider("BC") == null) {
                LogUtil.writeLog((String)"BC Provider not installed.");
            }
            LogUtil.writeErrorLog((String)"getKeyInfo Error", (Throwable)e);
            if (e instanceof KeyStoreException && "PKCS12".equals(type)) {
                Security.removeProvider("BC");
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static void printSysInfo() {
        LogUtil.writeLog((String)"================= SYS INFO begin====================");
        LogUtil.writeLog((String)("os_name:" + System.getProperty("os.name")));
        LogUtil.writeLog((String)("os_arch:" + System.getProperty("os.arch")));
        LogUtil.writeLog((String)("os_version:" + System.getProperty("os.version")));
        LogUtil.writeLog((String)("java_vm_specification_version:" + System.getProperty("java.vm.specification.version")));
        LogUtil.writeLog((String)("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor")));
        LogUtil.writeLog((String)("java_vm_specification_name:" + System.getProperty("java.vm.specification.name")));
        LogUtil.writeLog((String)("java_vm_version:" + System.getProperty("java.vm.version")));
        LogUtil.writeLog((String)("java_vm_name:" + System.getProperty("java.vm.name")));
        LogUtil.writeLog((String)("java.version:" + System.getProperty("java.version")));
        LogUtil.writeLog((String)("java.vm.vendor=[" + System.getProperty("java.vm.vendor") + "]"));
        LogUtil.writeLog((String)("java.version=[" + System.getProperty("java.version") + "]"));
        CertUtil.printProviders();
        LogUtil.writeLog((String)"================= SYS INFO end=====================");
    }

    public static void printProviders() {
        LogUtil.writeLog((String)"Providers List:");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LogUtil.writeLog((String)(i + 1 + "." + providers[i].getName()));
        }
    }

    public static String getCertIdByThreadLocal(String certPath, String certPwd) {
        CertUtil.initSignCert((String)certPath, (String)certPwd);
        try {
            Enumeration<String> aliasenum = ((KeyStore)KEY_STORE_THREAD_LOCAL.get()).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)((KeyStore)KEY_STORE_THREAD_LOCAL.get()).getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)"\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public static String getCertIdByKeyStoreMap(String certPath, String certPwd) {
        if (!STRING_KEY_STORE_CONCURRENT_HASH_MAP.containsKey(certPath)) {
            CertUtil.loadRsaCert((String)certPath, (String)certPwd);
        }
        return CertUtil.getCertIdIdByStore((KeyStore)((KeyStore)STRING_KEY_STORE_CONCURRENT_HASH_MAP.get(certPath)));
    }

    private static String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog((String)"getCertIdIdByStore Error", (Throwable)e);
            return null;
        }
    }

    public static Map<String, X509Certificate> getCertMap() {
        return certMap;
    }

    public static void setCertMap(Map<String, X509Certificate> certMap) {
        CertUtil.certMap = certMap;
    }

    public static PublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)("\u6784\u9020RSA\u516c\u94a5\u5931\u8d25\uff1a" + e));
            return null;
        }
    }

    public static PublicKey getEncryptTrackCertPublicKey(String modulus, String exponent) {
        if (SDKUtil.isEmpty((String)modulus) || SDKUtil.isEmpty((String)exponent)) {
            LogUtil.writeErrorLog((String)"[modulus] OR [exponent] invalid");
            return null;
        }
        return CertUtil.getPublicKey((String)modulus, (String)exponent);
    }

    static {
        CertUtil.init();
    }
}

