/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.unionpay.sdk;

import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.CertUtil;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.HttpClient;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.LogUtil;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.SDKUtil;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.SecureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class AcpService {
    public static String patten = "\\s*\"sign\"\\s*:\\s*\"([^\"]*)\"\\s*";
    public static String patten1 = "\\s*\"data\"\\s*:\\s*\"([^\"]*)\"\\s*";
    public static String patten3 = "cert_id=(\\d*)";

    public static Map<String, String> sign(Map<String, String> reqData, String encoding) {
        Map submitData = SDKUtil.filterBlank(reqData);
        SDKUtil.sign((Map)submitData, (String)encoding);
        return submitData;
    }

    public static Map<String, String> sign(Map<String, String> reqData, String certPath, String certPwd, String encoding) {
        Map submitData = SDKUtil.filterBlank(reqData);
        SDKUtil.signByCertInfo((Map)submitData, (String)certPath, (String)certPwd, (String)encoding);
        return submitData;
    }

    public static boolean validate(Map<String, String> rspData, String encoding) {
        LogUtil.writeLog((String)"\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb");
        if (SDKUtil.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        String stringSign = rspData.get("signature");
        String certId = rspData.get("certId");
        LogUtil.writeLog((String)("\u5bf9\u8fd4\u56de\u62a5\u6587\u4e32\u9a8c\u7b7e\u4f7f\u7528\u7684\u9a8c\u7b7e\u516c\u94a5\u5e8f\u5217\u53f7\uff1a[" + certId + "]"));
        String stringData = SDKUtil.coverMap2String(rspData);
        LogUtil.writeLog((String)("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]"));
        try {
            return SecureUtil.validateSignBySoft((PublicKey)CertUtil.getValidateKey((String)certId), (byte[])SecureUtil.base64Decode((byte[])stringSign.getBytes(encoding)), (byte[])SecureUtil.sha1X16((String)stringData, (String)encoding));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean validateAppResponse(String jsonData, String encoding) {
        Pattern p;
        Matcher m;
        LogUtil.writeLog((String)("\u63a7\u4ef6\u5e94\u7b54\u4fe1\u606f\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb\uff1a[" + jsonData + "]"));
        if (SDKUtil.isEmpty((String)encoding)) {
            encoding = "UTF-8";
        }
        if (!(m = (p = Pattern.compile(patten)).matcher(jsonData)).find()) {
            return false;
        }
        String sign = m.group(1);
        p = Pattern.compile(patten1);
        m = p.matcher(jsonData);
        if (!m.find()) {
            return false;
        }
        String data = m.group(1);
        p = Pattern.compile(patten3);
        m = p.matcher(jsonData);
        if (!m.find()) {
            return false;
        }
        String certId = m.group(1);
        try {
            return SecureUtil.validateSignBySoft((PublicKey)CertUtil.getValidateKey((String)certId), (byte[])SecureUtil.base64Decode((byte[])sign.getBytes(encoding)), (byte[])SecureUtil.sha1X16((String)data, (String)encoding));
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static Map<String, String> post(Map<String, String> reqData, String reqUrl, String encoding) {
        HashMap<String, String> rspData = new HashMap<String, String>(16);
        LogUtil.writeLog((String)("\u8bf7\u6c42\u94f6\u8054\u5730\u5740:" + reqUrl));
        HttpClient hc = new HttpClient(reqUrl, 30000, 30000);
        try {
            int status = hc.send(reqData, encoding);
            if (200 == status) {
                String resultString = hc.getResult();
                if (null != resultString && !"".equals(resultString)) {
                    Map tmpRspData = SDKUtil.convertResultStringToMap((String)resultString);
                    rspData.putAll(tmpRspData);
                }
            } else {
                LogUtil.writeLog((String)("\u8fd4\u56dehttp\u72b6\u6001\u7801[" + status + "]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u62a5\u6587\u6216\u8005\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e"));
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return rspData;
    }

    public static String get(String reqUrl, String encoding) {
        LogUtil.writeLog((String)("\u8bf7\u6c42\u94f6\u8054\u5730\u5740:" + reqUrl));
        HttpClient hc = new HttpClient(reqUrl, 30000, 30000);
        try {
            int status = hc.sendGet(encoding);
            if (200 == status) {
                String resultString = hc.getResult();
                if (null != resultString && !"".equals(resultString)) {
                    return resultString;
                }
            } else {
                LogUtil.writeLog((String)("\u8fd4\u56dehttp\u72b6\u6001\u7801[" + status + "]\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u62a5\u6587\u6216\u8005\u8bf7\u6c42\u5730\u5740\u662f\u5426\u6b63\u786e"));
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String createAutoFormHtml(String reqUrl, Map<String, String> hiddens, String encoding) {
        StringBuffer sf = new StringBuffer();
        sf.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/></head><body>");
        sf.append("<form id = \"pay_form\" action=\"" + reqUrl + "\" method=\"post\">");
        if (null != hiddens && 0 != hiddens.size()) {
            Set<Map.Entry<String, String>> set = hiddens.entrySet();
            for (Map.Entry<String, String> ey : set) {
                String key = ey.getKey();
                String value = ey.getValue();
                sf.append("<input type=\"hidden\" name=\"" + key + "\" id=\"" + key + "\" value=\"" + value + "\"/>");
            }
        }
        sf.append("</form>");
        sf.append("</body>");
        sf.append("<script type=\"text/javascript\">");
        sf.append("document.all.pay_form.submit();");
        sf.append("</script>");
        sf.append("</html>");
        return sf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String enCodeFileContent(String filePath, String encoding) {
        String baseFileContent = "";
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
            }
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int fl = ((InputStream)in).available();
            if (null != in) {
                byte[] s = new byte[fl];
                ((InputStream)in).read(s, 0, fl);
                baseFileContent = new String(SecureUtil.base64Encode((byte[])SecureUtil.deflater((byte[])s)), encoding);
            }
        }
        catch (Exception e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
                }
            }
        }
        return baseFileContent;
    }

    public static void deCodeFileContent(Map<String, String> resData, String fileDirectory, String encoding) {
        String fileContent = resData.get("fileContent");
        if (null != fileContent && !"".equals(fileContent)) {
            try {
                byte[] fileArray = SecureUtil.inflater((byte[])SecureUtil.base64Decode((byte[])fileContent.getBytes(encoding)));
                String filePath = null;
                filePath = SDKUtil.isEmpty((String)resData.get("fileName")) ? fileDirectory + File.separator + resData.get("merId") + "_" + resData.get("batchNo") + "_" + resData.get("txnTime") + ".txt" : fileDirectory + File.separator + resData.get("fileName");
                File file = new File(filePath);
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                FileOutputStream out = new FileOutputStream(file);
                out.write(fileArray, 0, fileArray.length);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getFileContent(String fileContent, String encoding) {
        String fc = "";
        try {
            fc = new String(SecureUtil.inflater((byte[])SecureUtil.base64Decode((byte[])fileContent.getBytes())), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return fc;
    }

    public static String getCustomerInfo(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        Iterator<String> it = customerInfoMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = customerInfoMap.get(key);
            if ("pin".equals(key)) {
                if (null == accNo || "".equals(accNo.trim())) {
                    LogUtil.writeLog((String)"\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfo\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin((String)accNo, (String)value, (String)encoding);
            }
            sf.append(key).append("=").append(value);
            if (!it.hasNext()) continue;
            sf.append("&");
        }
        String customerInfo = sf.append("}").toString();
        LogUtil.writeLog((String)("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo));
        try {
            return new String(SecureUtil.base64Encode((byte[])sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfo;
    }

    public static String getCustomerInfoWithEncrypt(Map<String, String> customerInfoMap, String accNo, String encoding) {
        if (customerInfoMap.isEmpty()) {
            return "{}";
        }
        StringBuffer sf = new StringBuffer("{");
        StringBuffer encryptedInfoSb = new StringBuffer("");
        for (String key : customerInfoMap.keySet()) {
            String value = customerInfoMap.get(key);
            if ("phoneNo".equals(key) || "cvn2".equals(key) || "expired".equals(key)) {
                encryptedInfoSb.append(key).append("=").append(value).append("&");
                continue;
            }
            if ("pin".equals(key)) {
                if (null == accNo || "".equals(accNo.trim())) {
                    LogUtil.writeLog((String)"\u9001\u4e86\u5bc6\u7801\uff08PIN\uff09\uff0c\u5fc5\u987b\u5728getCustomerInfoWithEncrypt\u53c2\u6570\u4e2d\u4e0a\u4f20\u5361\u53f7");
                    throw new RuntimeException("\u52a0\u5bc6PIN\u6ca1\u9001\u5361\u53f7\u65e0\u6cd5\u540e\u7eed\u5904\u7406");
                }
                value = AcpService.encryptPin((String)accNo, (String)value, (String)encoding);
            }
            sf.append(key).append("=").append(value).append("&");
        }
        if (!"".equals(encryptedInfoSb.toString())) {
            encryptedInfoSb.setLength(encryptedInfoSb.length() - 1);
            LogUtil.writeLog((String)("\u7ec4\u88c5\u7684customerInfo encryptedInfo\u660e\u6587\uff1a" + encryptedInfoSb.toString()));
            sf.append("encryptedInfo").append("=").append(AcpService.encryptData((String)encryptedInfoSb.toString(), (String)encoding));
        } else {
            sf.setLength(sf.length() - 1);
        }
        String customerInfo = sf.append("}").toString();
        LogUtil.writeLog((String)("\u7ec4\u88c5\u7684customerInfo\u660e\u6587\uff1a" + customerInfo));
        try {
            return new String(SecureUtil.base64Encode((byte[])sf.toString().getBytes(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfo;
    }

    public static Map<String, String> parseCustomerInfo(String customerInfo, String encoding) {
        Map customerInfoMap = null;
        try {
            byte[] b = SecureUtil.base64Decode((byte[])customerInfo.getBytes(encoding));
            String customerInfoNoBase64 = new String(b, encoding);
            LogUtil.writeLog((String)("\u89e3base64\u540e===>" + customerInfoNoBase64));
            customerInfoNoBase64 = customerInfoNoBase64.substring(1, customerInfoNoBase64.length() - 1);
            customerInfoMap = SDKUtil.parseQString((String)customerInfoNoBase64);
            if (customerInfoMap.containsKey("encryptedInfo")) {
                String encInfoStr = (String)customerInfoMap.get("encryptedInfo");
                customerInfoMap.remove("encryptedInfo");
                String encryptedInfoStr = AcpService.decryptData((String)encInfoStr, (String)encoding);
                Map encryptedInfoMap = SDKUtil.parseQString((String)encryptedInfoStr);
                customerInfoMap.putAll(encryptedInfoMap);
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LogUtil.writeErrorLog((String)e.getMessage(), (Throwable)e);
        }
        return customerInfoMap;
    }

    public static String encryptPin(String accNo, String pwd, String encoding) {
        return SecureUtil.encryptPin((String)pwd, (String)accNo, (String)encoding, (PublicKey)CertUtil.getEncryptCertPublicKey());
    }

    public static String encryptData(String data, String encoding) {
        return SecureUtil.encryptData((String)data, (String)encoding, (PublicKey)CertUtil.getEncryptCertPublicKey());
    }

    public static String decryptData(String base64EncryptedInfo, String encoding) {
        return SecureUtil.decryptedData((String)base64EncryptedInfo, (String)encoding, (PrivateKey)CertUtil.getSignCertPrivateKey());
    }

    public static String encryptTrack(String trackData, String encoding) {
        return SecureUtil.encryptData((String)trackData, (String)encoding, (PublicKey)CertUtil.getEncryptTrackPublicKey());
    }

    public static String encryptTrack(String trackData, String encoding, String modulus, String exponent) {
        return SecureUtil.encryptData((String)trackData, (String)encoding, (PublicKey)CertUtil.getEncryptTrackCertPublicKey((String)modulus, (String)exponent));
    }

    public static String getEncryptCertId() {
        return CertUtil.getEncryptCertId();
    }

    public static String base64Encode(String rawStr, String encoding) throws IOException {
        byte[] rawByte = rawStr.getBytes(encoding);
        return new String(SecureUtil.base64Encode((byte[])rawByte), encoding);
    }

    public static String base64Decode(String base64Str, String encoding) throws IOException {
        byte[] rawByte = base64Str.getBytes(encoding);
        return new String(SecureUtil.base64Decode((byte[])rawByte), encoding);
    }
}

