/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.unionpay;

import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.payment.enums.UnionpayConfigItem;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.service.payment.AbstractPaymentPlugin;
import com.enation.app.javashop.service.payment.plugin.unionpay.UnionpayConfig;
import com.enation.app.javashop.service.payment.plugin.unionpay.sdk.SDKConfig;
import java.util.Map;
import java.util.Properties;

public class UnionpayPluginConfig
extends AbstractPaymentPlugin {
    private static int is_load = 0;

    protected String getPluginId() {
        return "unionpayPlugin";
    }

    public void setConfig(PayBill bill) {
        Map params = this.getConfig(bill.getClientType());
        UnionpayConfig.merId = (String)params.get(UnionpayConfigItem.mer_id.name());
        if (is_load == 1 && this.isTest == 1) {
            return;
        }
        String signCert = (String)params.get(UnionpayConfigItem.sign_cert.name());
        String pwd = (String)params.get(UnionpayConfigItem.pwd.name());
        String validateCert = (String)params.get(UnionpayConfigItem.validate_cert.name());
        String encryptCert = (String)params.get(UnionpayConfigItem.encrypt_cert.name());
        if (StringUtil.isEmpty((String)signCert)) {
            throw new ServiceException(PaymentErrorCode.E505.code(), "\u652f\u4ed8\u65b9\u5f0f\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isEmpty((String)pwd)) {
            throw new ServiceException(PaymentErrorCode.E505.code(), "\u652f\u4ed8\u65b9\u5f0f\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isEmpty((String)validateCert)) {
            throw new ServiceException(PaymentErrorCode.E505.code(), "\u652f\u4ed8\u65b9\u5f0f\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        Properties pro = new Properties();
        pro.setProperty("acpsdk.signCert.type", "PKCS12");
        pro.setProperty("acpsdk.signCert.path", signCert);
        pro.setProperty("acpsdk.signCert.pwd", pwd);
        pro.setProperty("acpsdk.validateCert.dir", validateCert);
        if (this.isTest == 0) {
            pro.setProperty("acpsdk.frontTransUrl", "https://gateway.test.95516.com/gateway/api/frontTransReq.do");
            pro.setProperty("acpsdk.backTransUrl", "https://gateway.test.95516.com/gateway/api/backTransReq.do");
            pro.setProperty("acpsdk.singleQueryUrl", "https://gateway.test.95516.com/gateway/api/queryTrans.do");
            pro.setProperty("acpsdk.batchTransUrl", "https://gateway.test.95516.com/gateway/api/batchTrans.do");
            pro.setProperty("acpsdk.fileTransUrl", "https://filedownload.test.95516.com/");
            pro.setProperty("acpsdk.appTransUrl", "https://gateway.test.95516.com/gateway/api/appTransReq.do");
            pro.setProperty("acpsdk.cardTransUrl", "https://gateway.test.95516.com/gateway/api/cardTransReq.do");
        }
        if (this.isTest == 1) {
            pro.setProperty("acpsdk.frontTransUrl", "https://gateway.95516.com/gateway/api/frontTransReq.do");
            pro.setProperty("acpsdk.backTransUrl", "https://gateway.95516.com/gateway/api/backTransReq.do");
            pro.setProperty("acpsdk.singleQueryUrl", "https://gateway.95516.com/gateway/api/queryTrans.do");
            pro.setProperty("acpsdk.batchTransUrl", "https://gateway.95516.com/gateway/api/batchTrans.do");
            pro.setProperty("acpsdk.fileTransUrl", "https://filedownload.95516.com/");
            pro.setProperty("acpsdk.appTransUrl", "https://gateway.95516.com/gateway/api/appTransReq.do");
            pro.setProperty("acpsdk.cardTransUrl", "https://gateway.95516.com/gateway/api/cardTransReq.do");
        }
        if (!StringUtil.isEmpty((String)encryptCert)) {
            pro.setProperty("acpsdk.encryptCert.path", encryptCert);
        }
        SDKConfig.getConfig().loadProperties(pro);
        is_load = 1;
    }
}

