/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.unionAffairs;

import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.enums.UnionAffairsConfigItem;
import com.enation.app.javashop.model.payment.vo.ClientConfig;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.payment.vo.PayConfigItem;
import com.enation.app.javashop.model.payment.vo.RefundBill;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.AbstractPaymentPlugin;
import com.enation.app.javashop.service.payment.OrderRefundManager;
import com.enation.app.javashop.service.payment.PaymentPluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnionAffairsPlugin
extends AbstractPaymentPlugin
implements PaymentPluginManager {
    @Autowired
    private OrderRefundManager orderRefundManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String getPluginId() {
        return "unionAffairsPlugin";
    }

    public String getPluginName() {
        return "\u94f6\u8054\u5546\u52a1";
    }

    public List<ClientConfig> definitionClientConfig() {
        ArrayList<ClientConfig> resultList = new ArrayList<ClientConfig>();
        ClientConfig config = new ClientConfig();
        ArrayList<PayConfigItem> configList = new ArrayList<PayConfigItem>();
        for (UnionAffairsConfigItem value : UnionAffairsConfigItem.values()) {
            PayConfigItem item = new PayConfigItem();
            item.setName(value.name());
            item.setText(value.getText());
            configList.add(item);
        }
        config.setKey(ClientType.PC.getDbColumn() + "&" + ClientType.WAP.getDbColumn() + "&" + ClientType.NATIVE.getDbColumn() + "&" + ClientType.REACT.getDbColumn());
        config.setConfigList(configList);
        config.setName("\u662f\u5426\u5f00\u542f");
        resultList.add(config);
        return resultList;
    }

    public Map pay(PayBill bill) {
        return null;
    }

    public void onReturn(TradeTypeEnum tradeType) {
    }

    public String onCallback(ClientType clientType) {
        try {
            HttpServletRequest request = ThreadContextHolder.getHttpRequest();
            String orderSn = request.getParameter("merOrderId");
            String respCode = request.getParameter("status");
            String queryId = request.getParameter("queryId");
            String tradeno = request.getParameter("traceNo");
            String totalAmount = request.getParameter("totalAmount");
            double payPrice = StringUtil.toDouble((String)totalAmount, (Double)0.0);
            payPrice = CurrencyUtil.mul((double)payPrice, (double)0.01);
            if ("TRADE_SUCCESS".equals(respCode)) {
                this.logger.info("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de\u6210\u529f====" + request);
                this.logger.error("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de\u6210\u529f====" + request);
                this.paySuccess(orderSn, queryId, payPrice);
                return "SUCCESS";
            }
            this.logger.info("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de\u5931\u8d25====" + request);
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:");
        }
        catch (Exception e) {
            this.logger.info("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de\u5931\u8d25====" + e);
            this.logger.error("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de\u5931\u8d25====" + e);
            e.printStackTrace();
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25" + e.getMessage());
        }
    }

    public String onQuery(String billSn, Map config) {
        return null;
    }

    public boolean onTradeRefund(RefundBill bill) {
        return this.orderRefundManager.refundOrder(bill);
    }

    public String queryRefundStatus(RefundBill bill) {
        return this.orderRefundManager.queryRefundStatus(bill);
    }

    public Integer getIsRetrace() {
        return null;
    }

    public void closeTrade(Map<String, String> configMap, String outTradeNo) {
    }
}

