/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.couponPay;

import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.enums.CouponPayConfigItem;
import com.enation.app.javashop.model.payment.vo.ClientConfig;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.payment.vo.PayConfigItem;
import com.enation.app.javashop.model.payment.vo.RefundBill;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.AbstractPaymentPlugin;
import com.enation.app.javashop.service.payment.PaymentPluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class CouponPlugin
extends AbstractPaymentPlugin
implements PaymentPluginManager {
    public String getPluginId() {
        return "couponPlugin";
    }

    public String getPluginName() {
        return "\u4f18\u60e0\u5238\u652f\u4ed8";
    }

    public List<ClientConfig> definitionClientConfig() {
        ArrayList<ClientConfig> resultList = new ArrayList<ClientConfig>();
        ClientConfig config = new ClientConfig();
        ArrayList<PayConfigItem> configList = new ArrayList<PayConfigItem>();
        for (CouponPayConfigItem value : CouponPayConfigItem.values()) {
            PayConfigItem item = new PayConfigItem();
            item.setName(value.name());
            item.setText(value.getText());
            configList.add(item);
        }
        config.setKey(ClientType.PC.getDbColumn() + "&" + ClientType.WAP.getDbColumn() + "&" + ClientType.NATIVE.getDbColumn() + "&" + ClientType.REACT.getDbColumn());
        config.setConfigList(configList);
        config.setName("\u662f\u5426\u5f00\u542f");
        resultList.add(config);
        return resultList;
    }

    public Map pay(PayBill bill) {
        return null;
    }

    public void onReturn(TradeTypeEnum tradeType) {
    }

    public String onCallback(ClientType clientType) {
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        String orderSn = request.getParameter("merOrderId");
        try {
            String respCode = request.getParameter("status");
            String queryId = request.getParameter("queryId");
            String tradeno = request.getParameter("traceNo");
            String totalAmount = request.getParameter("totalAmount");
            double payPrice = StringUtil.toDouble((String)totalAmount, (Double)0.0);
            payPrice = CurrencyUtil.mul((double)payPrice, (double)0.01);
            if ("TRADE_SUCCESS".equals(respCode)) {
                this.paySuccess(orderSn, queryId, payPrice);
                return orderSn;
            }
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:");
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public String onQuery(String billSn, Map config) {
        return null;
    }

    public boolean onTradeRefund(RefundBill bill) {
        return false;
    }

    public String queryRefundStatus(RefundBill bill) {
        return null;
    }

    public Integer getIsRetrace() {
        return null;
    }

    public void closeTrade(Map<String, String> configMap, String outTradeNo) {
    }
}

