/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.alipay.executor;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.internal.util.AlipayEncrypt;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.LoadTestUtil;
import com.alipay.api.internal.util.RequestParametersHolder;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.WebUtils;
import com.alipay.api.internal.util.json.JSONWriter;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.model.payment.vo.Form;
import com.enation.app.javashop.model.payment.vo.FormItem;
import java.io.IOException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class JavaShopPayClient
extends DefaultAlipayClient {
    private String serverUrl;
    private String appId;
    private String privateKey;
    private String prodCode;
    private String format = "json";
    private String signType = "RSA";
    private String encryptKey;
    private String encryptType = "AES";
    private String charset;

    public JavaShopPayClient(String serverUrl, String appId, String privateKey) {
        super(serverUrl, appId, privateKey);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
    }

    public JavaShopPayClient(String serverUrl, String appId, String privateKey, String format) {
        super(serverUrl, appId, privateKey, format);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.format = format;
    }

    public JavaShopPayClient(String serverUrl, String appId, String privateKey, String format, String charset) {
        super(serverUrl, appId, privateKey, format, charset);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.format = format;
        this.charset = charset;
    }

    public JavaShopPayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey) {
        super(serverUrl, appId, privateKey, format, charset, alipayPublicKey);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.format = format;
        this.charset = charset;
    }

    public JavaShopPayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey, String signType) {
        super(serverUrl, appId, privateKey, format, charset, alipayPublicKey, signType);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.format = format;
        this.charset = charset;
        this.signType = signType;
    }

    public JavaShopPayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey, String signType, String proxyHost, int proxyPort) {
        super(serverUrl, appId, privateKey, format, charset, alipayPublicKey, signType, proxyHost, proxyPort);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.format = format;
        this.charset = charset;
        this.signType = signType;
    }

    public JavaShopPayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey, String signType, String encryptKey, String encryptType) {
        super(serverUrl, appId, privateKey, format, charset, alipayPublicKey, signType, encryptKey, encryptType);
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
        this.format = format;
        this.charset = charset;
        this.signType = signType;
        this.encryptType = encryptType;
    }

    public JavaShopPayClient(CertAlipayRequest certAlipayRequest) throws AlipayApiException {
        super(certAlipayRequest);
    }

    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request) throws AlipayApiException {
        return (T)this.pageExecute(request, "POST");
    }

    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request, String httpMethod) throws AlipayApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug((String)this.getRedirectUrl(requestHolder));
        }
        AlipayResponse rsp = null;
        try {
            Class clazz = request.getResponseClass();
            rsp = (AlipayResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError((Throwable)e);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            rsp.setBody(this.getRedirectUrl(requestHolder));
        } else {
            rsp.setBody(JsonUtil.objectToJson((Object)this.getFormData(requestHolder)));
        }
        return (T)rsp;
    }

    private <T extends AlipayResponse> RequestParametersHolder getRequestHolderWithSign(AlipayRequest<?> request, String accessToken, String appAuthToken) throws AlipayApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap appParams = new AlipayHashMap(request.getTextParams());
        try {
            if (request.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)((String)appParams.get((Object)"biz_content"))) && request.getBizModel() != null) {
                appParams.put("biz_content", new JSONWriter().write((Object)request.getBizModel(), true));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            AlipayLogger.logBizError((Throwable)e);
        }
        if (request.isNeedEncrypt()) {
            if (StringUtils.isEmpty((String)((String)appParams.get((Object)"biz_content")))) {
                throw new AlipayApiException("\u5f53\u524dAPI\u4e0d\u652f\u6301\u52a0\u5bc6\u8bf7\u6c42");
            }
            if (!StringUtils.areNotEmpty((String[])new String[]{this.encryptKey, this.encryptType})) {
                throw new AlipayApiException("API\u8bf7\u6c42\u8981\u6c42\u52a0\u5bc6\uff0c\u5219\u5fc5\u987b\u8bbe\u7f6e\u5bc6\u94a5\u548c\u5bc6\u94a5\u7c7b\u578b\uff1aencryptKey=" + this.encryptKey + ",encryptType=" + this.encryptType);
            }
            String encryptContent = AlipayEncrypt.encryptContent((String)((String)appParams.get((Object)"biz_content")), (String)this.encryptType, (String)this.encryptKey, (String)this.charset);
            appParams.put("biz_content", encryptContent);
        }
        if (!StringUtils.isEmpty((String)appAuthToken)) {
            appParams.put("app_auth_token", appAuthToken);
        }
        requestHolder.setApplicationParams(appParams);
        if (StringUtils.isEmpty((String)this.charset)) {
            this.charset = "UTF-8";
        }
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", request.getApiVersion());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.signType);
        protocalMustParams.put("terminal_type", request.getTerminalType());
        protocalMustParams.put("terminal_info", request.getTerminalInfo());
        protocalMustParams.put("notify_url", request.getNotifyUrl());
        protocalMustParams.put("return_url", request.getReturnUrl());
        protocalMustParams.put("charset", this.charset);
        if (request.isNeedEncrypt()) {
            protocalMustParams.put("encrypt_type", this.encryptType);
        }
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        AlipayHashMap protocalOptParams = new AlipayHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("auth_token", accessToken);
        protocalOptParams.put("alipay_sdk", "alipay-sdk-java-dynamicVersionNo");
        protocalOptParams.put("prod_code", request.getProdCode());
        requestHolder.setProtocalOptParams(protocalOptParams);
        if (!StringUtils.isEmpty((String)this.signType)) {
            String signContent = AlipaySignature.getSignatureContent((RequestParametersHolder)requestHolder);
            protocalMustParams.put("sign", AlipaySignature.rsaSign((String)signContent, (String)this.privateKey, (String)this.charset, (String)this.signType));
        } else {
            protocalMustParams.put("sign", "");
        }
        return requestHolder;
    }

    private Form getFormData(RequestParametersHolder requestHolder) throws AlipayApiException {
        if (requestHolder.getApplicationParams() != null && !requestHolder.getApplicationParams().isEmpty()) {
            Form form = new Form();
            ArrayList<FormItem> formItems = new ArrayList<FormItem>();
            Set keys = requestHolder.getApplicationParams().keySet();
            Iterator var3 = keys.iterator();
            while (var3.hasNext()) {
                FormItem item = new FormItem();
                String key = (String)var3.next();
                String value = (String)requestHolder.getApplicationParams().get((Object)key);
                item.setItemName(key);
                item.setItemValue(value.replace("\"", "&quot;"));
                formItems.add(item);
            }
            form.setFormItems(formItems);
            form.setGatewayUrl(this.getRequestUrl(requestHolder).toString());
            return form;
        }
        return null;
    }

    private String getRequestUrl(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuilder urlSb = new StringBuilder(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery((Map)(this.loadTest ? LoadTestUtil.getParamsWithLoadTestFlag((Map)requestHolder.getProtocalMustParams()) : requestHolder.getProtocalMustParams()), (String)this.charset);
            String sysOptQuery = WebUtils.buildQuery((Map)requestHolder.getProtocalOptParams(), (String)this.charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null && sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException((Throwable)e);
        }
        return urlSb.toString();
    }

    private String getRedirectUrl(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuilder urlSb = new StringBuilder(this.serverUrl);
        try {
            Map sortedMap = AlipaySignature.getSortedMap((RequestParametersHolder)requestHolder);
            String sortedQuery = WebUtils.buildQuery((Map)(this.loadTest ? LoadTestUtil.getParamsWithLoadTestFlag((Map)sortedMap) : sortedMap), (String)this.charset);
            urlSb.append("?");
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new AlipayApiException((Throwable)e);
        }
        return urlSb.toString();
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

