/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.alipay.executor;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.model.aftersale.enums.RefundStatusEnum;
import com.enation.app.javashop.model.payment.vo.RefundBill;
import com.enation.app.javashop.service.payment.plugin.alipay.AlipayPluginConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlipayRefundExcutor
extends AlipayPluginConfig {
    @Autowired
    private Cache cache;
    @Autowired
    private Debugger debugger;

    public boolean refundPay(RefundBill bill) {
        try {
            Map config = bill.getConfigMap();
            this.debugger.log(new String[]{"\u57fa\u7840\u53c2\u6570\u4e3a", config.toString()});
            AlipayClient alipayClient = this.buildClient(config);
            AlipayTradeRefundRequest alipayRequest = new AlipayTradeRefundRequest();
            Double refundAmount = bill.getRefundPrice();
            String refundReason = "\u6b63\u5e38\u9000\u6b3e";
            String outRequestNo = bill.getRefundSn();
            HashMap<String, String> sParaTemp = new HashMap<String, String>(16);
            sParaTemp.put("trade_no", bill.getReturnTradeNo());
            sParaTemp.put("refund_amount", refundAmount + "");
            sParaTemp.put("refund_reason", refundReason);
            sParaTemp.put("out_request_no", outRequestNo);
            this.debugger.log(new String[]{"\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a", ((Object)sParaTemp).toString()});
            ObjectMapper json = new ObjectMapper();
            alipayRequest.setBizContent(json.writeValueAsString(sParaTemp));
            this.debugger.log("\u5411\u652f\u4ed8\u5b9d\u53d1\u51fa\u8bf7\u6c42");
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            this.debugger.log("\u8bf7\u6c42\u7ed3\u679c\uff1a" + response.isSuccess());
            if (response.isSuccess()) {
                return true;
            }
            this.cache.put((Object)("{REFUND_ERROR_MESSAGE}_" + bill.getRefundSn()), (Object)(response.getCode() + ":" + response.getSubMsg()));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String queryRefundStatus(RefundBill bill) {
        try {
            Map config = bill.getConfigMap();
            AlipayClient alipayClient = this.buildClient(config);
            AlipayTradeFastpayRefundQueryRequest alipayRequest = new AlipayTradeFastpayRefundQueryRequest();
            String tradeNo = bill.getReturnTradeNo();
            String refundSn = bill.getRefundSn();
            HashMap<String, String> sParaTemp = new HashMap<String, String>(16);
            sParaTemp.put("trade_no", tradeNo);
            sParaTemp.put("out_request_no", refundSn);
            ObjectMapper json = new ObjectMapper();
            alipayRequest.setBizContent(json.writeValueAsString(sParaTemp));
            AlipayTradeFastpayRefundQueryResponse response = (AlipayTradeFastpayRefundQueryResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                if (response.getOutTradeNo() != null) {
                    return RefundStatusEnum.COMPLETED.value();
                }
                return RefundStatusEnum.REFUNDING.value();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return RefundStatusEnum.REFUNDING.value();
    }
}

