/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.alipay.executor;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeWapPayResponse;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.service.payment.plugin.alipay.AlipayPluginConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class AliPayPaymentWapExecutor
extends AlipayPluginConfig {
    public Map onPay(PayBill bill) {
        try {
            AlipayClient alipayClient = super.buildClient(bill.getClientType());
            AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
            alipayRequest.setNotifyUrl(this.getCallBackUrl(bill.getTradeType(), bill.getClientType()));
            alipayRequest.setReturnUrl(this.getReturnUrl(bill));
            Map sParaTemp = this.createParam(bill);
            ObjectMapper json = new ObjectMapper();
            String bizContent = json.writeValueAsString((Object)sParaTemp);
            alipayRequest.setBizContent(bizContent);
            return JsonUtil.toMap((String)((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)alipayRequest)).getBody());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

