/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.alipay.executor;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.enums.PayMode;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.plugin.alipay.AlipayPluginConfig;
import com.enation.app.javashop.service.payment.plugin.alipay.JavashopAlipayUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliPayPaymentExecutor
extends AlipayPluginConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Debugger debugger;

    public Map onPay(PayBill bill) {
        try {
            AlipayClient alipayClient = super.buildClient(bill.getClientType());
            AlipayTradePagePayRequest alipayRequest = new AlipayTradePagePayRequest();
            alipayRequest.setReturnUrl(this.getReturnUrl(bill));
            alipayRequest.setNotifyUrl(this.getCallBackUrl(bill.getTradeType(), bill.getClientType()));
            this.debugger.log("callback url is ");
            this.debugger.log(alipayRequest.getNotifyUrl());
            Map sParaTemp = this.createParam(bill);
            if (PayMode.qr.name().equals(bill.getPayMode())) {
                sParaTemp.put("qr_pay_mode", "4");
                sParaTemp.put("qrcode_width", "200");
            }
            ObjectMapper json = new ObjectMapper();
            String bizContent = json.writeValueAsString((Object)sParaTemp);
            alipayRequest.setBizContent(bizContent);
            AlipayResponse response = alipayClient.pageExecute((AlipayRequest)alipayRequest);
            return JsonUtil.toMap((String)response.getBody());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public String onReturn(TradeTypeEnum tradeType) {
        String billSn = "";
        try {
            HttpServletRequest request = ThreadContextHolder.getHttpRequest();
            billSn = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String returnTradeNo = new String(request.getParameter("trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String totalAmount = request.getParameter("total_amount");
            Map cfgparams = this.getConfig(ClientType.PC);
            String alipayPublicKey = (String)cfgparams.get("alipay_public_key");
            if (!JavashopAlipayUtil.verify((String)alipayPublicKey)) {
                throw new ServiceException(PaymentErrorCode.E503.code(), "\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return billSn;
    }

    public String onCallback(ClientType clientType) {
        this.debugger.log("\u8fdb\u5165\u652f\u4ed8\u5b9d\u56de\u8c03");
        try {
            HttpServletRequest request = ThreadContextHolder.getHttpRequest();
            String outBizNo = request.getParameter("out_biz_no");
            String refundFee = request.getParameter("refund_fee");
            String gmtRefund = request.getParameter("gmt_refund");
            if (!(StringUtil.isEmpty((String)outBizNo) || StringUtil.isEmpty((String)refundFee) || StringUtil.isEmpty((String)gmtRefund))) {
                this.logger.debug("\u90e8\u5206\u9000\u6b3e\u901a\u77e5\u53c2\u6570\uff1a");
                this.logger.debug("outBizNo:" + outBizNo);
                this.logger.debug("refundFee:" + refundFee);
                this.logger.debug("gmtRefund:" + gmtRefund);
                return "fail";
            }
            String outTradeNo = new String(request.getParameter("out_trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String returnTradeNo = new String(request.getParameter("trade_no").getBytes("ISO-8859-1"), "UTF-8");
            String tradeStatus = new String(request.getParameter("trade_status").getBytes("ISO-8859-1"), "UTF-8");
            String totalAmount = request.getParameter("total_amount");
            Map cfgparams = this.getConfig(clientType);
            String alipayPublicKey = (String)cfgparams.get("alipay_public_key");
            this.debugger.log("outTradeNo:[" + outTradeNo + "],returnTradeNo:[" + returnTradeNo + "],tradeStatus:[" + tradeStatus + "],totalAmount:[" + totalAmount + "]");
            this.debugger.log("alipayPublicKey:");
            this.debugger.log(alipayPublicKey);
            if (JavashopAlipayUtil.verify((String)alipayPublicKey)) {
                this.debugger.log("\u9a8c\u8bc1\u6210\u529f");
                if ("TRADE_SUCCESS".equals(tradeStatus) || "TRADE_FINISHED".equals(tradeStatus)) {
                    double payPrice = StringUtil.toDouble((String)totalAmount, (Double)0.0);
                    this.paySuccess(outTradeNo, returnTradeNo, payPrice);
                }
                return "success";
            }
            this.debugger.log("\u9a8c\u8bc1\u5931\u8d25");
            return "fail";
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return "fail";
        }
    }

    public String onQuery(String billSn, Map config) {
        AlipayClient alipayClient = super.buildClient(config);
        AlipayTradeQueryRequest alipayRequest = new AlipayTradeQueryRequest();
        String outTradeNo = billSn;
        HashMap<String, String> sParaTemp = new HashMap<String, String>(16);
        sParaTemp.put("out_trade_no", billSn);
        ObjectMapper json = new ObjectMapper();
        try {
            alipayRequest.setBizContent(json.writeValueAsString(sParaTemp));
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                String tradeStatus = response.getTradeStatus();
                if ("TRADE_SUCCESS".equals(tradeStatus) || "TRADE_FINISHED".equals(tradeStatus)) {
                    String totalAmount = response.getTotalAmount();
                    double payPrice = StringUtil.toDouble((String)totalAmount, (Double)0.0);
                    String returnTradeNo = response.getTradeNo();
                    this.paySuccess(outTradeNo, returnTradeNo, payPrice);
                }
            } else {
                this.logger.error("\u652f\u4ed8\u67e5\u8be2\u5931\u8d25");
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return "";
    }
}

