/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.alipay.executor;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.service.payment.plugin.alipay.AlipayPluginConfig;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class AliPayPaymentAppExecutor
extends AlipayPluginConfig {
    public Map onPay(PayBill bill) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            AlipayClient alipayClient = super.buildClient(bill.getClientType());
            AlipayTradeAppPayRequest alipayRequest = new AlipayTradeAppPayRequest();
            alipayRequest.setNotifyUrl(this.getCallBackUrl(bill.getTradeType(), bill.getClientType()));
            String outTradeNo = bill.getBillSn();
            double payMoney = bill.getOrderPrice();
            String subject = this.getSiteName() + "\u8ba2\u5355-" + bill.getSubSn();
            String body = "";
            AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
            model.setBody(body);
            model.setSubject(subject);
            model.setOutTradeNo(outTradeNo);
            model.setTimeoutExpress("30m");
            model.setTotalAmount(payMoney + "");
            model.setProductCode("QUICK_MSECURITY_PAY");
            alipayRequest.setBizModel((AlipayObject)model);
            result.put("gateway_url", ((AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)alipayRequest)).getBody());
            return result;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

