/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.plugin.alipay;

import com.alipay.api.AlipayClient;
import com.enation.app.javashop.client.system.SettingClient;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.model.base.SettingGroup;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.system.vo.SiteSetting;
import com.enation.app.javashop.service.payment.AbstractPaymentPlugin;
import com.enation.app.javashop.service.payment.plugin.alipay.AlipayConfig;
import com.enation.app.javashop.service.payment.plugin.alipay.executor.JavaShopPayClient;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class AlipayPluginConfig
extends AbstractPaymentPlugin {
    @Autowired
    private Debugger debugger;
    @Autowired
    private SettingClient settingClient;

    protected String getPluginId() {
        return "alipayDirectPlugin";
    }

    protected AlipayClient buildClient(ClientType clientType) {
        Map config = this.getConfig(clientType);
        return this.buildClient(config);
    }

    protected AlipayClient buildClient(Map<String, String> config) {
        String appId = config.get("app_id");
        String merchantPrivateKey = config.get("merchant_private_key");
        String alipayPublicKey = config.get("alipay_public_key");
        this.debugger.log("\u4f7f\u7528\u5982\u4e0b\u53c2\u6570\u6784\u5efaclient:");
        this.debugger.log(config.toString());
        JavaShopPayClient alipayClient = new JavaShopPayClient(AlipayConfig.gatewayUrl, appId, merchantPrivateKey, "json", AlipayConfig.charset, alipayPublicKey, AlipayConfig.signType);
        return alipayClient;
    }

    protected Map<String, String> createParam(PayBill bill) {
        String outTradeNo = bill.getBillSn();
        Double payMoney = bill.getOrderPrice();
        String subject = this.getSiteName() + "\u8ba2\u5355-" + bill.getSubSn();
        HashMap<String, String> sParaTemp = new HashMap<String, String>(16);
        sParaTemp.put("out_trade_no", outTradeNo);
        sParaTemp.put("product_code", "FAST_INSTANT_TRADE_PAY");
        sParaTemp.put("total_amount", payMoney + "");
        sParaTemp.put("subject", subject);
        sParaTemp.put("body", "");
        return sParaTemp;
    }

    protected String getSiteName() {
        String siteSettingJson = this.settingClient.get(SettingGroup.SITE);
        SiteSetting siteSetting = (SiteSetting)JsonUtil.jsonToObject((String)siteSettingJson, SiteSetting.class);
        return siteSetting.getSiteName();
    }
}

