/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import com.enation.app.javashop.service.payment.WechatSmallchangeManager;
import com.enation.app.javashop.service.payment.plugin.weixin.WeixinUtil;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatSmallchangeManagerImpl
implements WechatSmallchangeManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaymentMethodManager paymentMethodManager;
    private String PAY_BASE_URL = "https://api.mch.weixin.qq.com";

    public boolean autoSend(String openId, Double price, String ip, String sn) {
        try {
            Map returnParams = null;
            Map config = this.paymentMethodManager.getConfig(ClientType.WAP.getDbColumn(), "weixinPayPlugin");
            String appId = (String)config.get("appid");
            String mchId = (String)config.get("mchid");
            String key = (String)config.get("key");
            String p12 = (String)config.get("p12_path");
            File file = new File(p12);
            if (!file.exists()) {
                return false;
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("mch_appid", appId);
            params.put("mchid", mchId);
            params.put("nonce_str", StringUtil.getRandStr((int)10));
            params.put("openid", openId);
            params.put("partner_trade_no", sn);
            params.put("check_name", "NO_CHECK");
            params.put("amount", CurrencyUtil.toFen((Double)price));
            params.put("desc", "\u4f63\u91d1\u63d0\u73b0");
            params.put("spbill_create_ip", ip);
            String sign = WeixinUtil.createSign(params, (String)key);
            params.put("sign", sign);
            String url = this.PAY_BASE_URL + "/mmpaymkttransfers/promotion/transfers";
            String xml = null;
            try {
                xml = WeixinUtil.mapToXml(params);
            }
            catch (Exception e) {
                this.logger.error("\u4e0d\u89c4\u8303\u7684\u53c2\u6570:" + JsonUtil.objectToJson(params));
                throw new ServiceException("\u4e0d\u89c4\u8303\u7684\u53c2\u6570", e.getMessage());
            }
            this.logger.debug("url:" + url);
            this.logger.debug("params:" + xml);
            Document resultDoc = WeixinUtil.verifyCertPost((String)url, (String)xml, (String)mchId, (String)p12);
            returnParams = WeixinUtil.xmlToMap((Document)resultDoc);
            this.logger.debug("WechatMpService.entPay result:" + JsonUtil.objectToJson((Object)returnParams));
            String errCode = (String)returnParams.get("err_code");
            return StringUtil.isEmpty((String)errCode);
        }
        catch (Exception e) {
            this.logger.error("\u96f6\u94b1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

