/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.enation.app.javashop.client.goods.GoodsClient;
import com.enation.app.javashop.client.member.MemberInfoRestClient;
import com.enation.app.javashop.client.promotion.PayTemplateInterfaceClient;
import com.enation.app.javashop.client.trade.OrderClient;
import com.enation.app.javashop.client.trade.SyncOrderClient;
import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.DateUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.aftersale.dos.AfterSaleServiceDO;
import com.enation.app.javashop.model.aftersale.dos.RefundDO;
import com.enation.app.javashop.model.aftersale.vo.AfterSaleGoodsVO;
import com.enation.app.javashop.model.base.ZTPaySetting;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.goods.dos.ItemChannelFull;
import com.enation.app.javashop.model.payment.dos.PaymentBillDO;
import com.enation.app.javashop.model.payment.dos.PaymentChannleDO;
import com.enation.app.javashop.model.payment.vo.ChannelMethodRelVO;
import com.enation.app.javashop.model.payment.vo.ChannelRelVO;
import com.enation.app.javashop.model.payment.vo.OperAttrStruct;
import com.enation.app.javashop.model.payment.vo.PayChannelAttr;
import com.enation.app.javashop.model.payment.vo.PayChannelMethodDetailAttr;
import com.enation.app.javashop.model.payment.vo.RefundAssemblyAttrDTO;
import com.enation.app.javashop.model.payment.vo.RefundBill;
import com.enation.app.javashop.model.payment.vo.RefundOrderRespDTO;
import com.enation.app.javashop.model.trade.order.dos.OrderDO;
import com.enation.app.javashop.model.trade.order.dos.OrderItemsDO;
import com.enation.app.javashop.model.trade.order.dto.ZTOrderPaymentParam;
import com.enation.app.javashop.model.trade.order.dto.ZTReverseOrderParam;
import com.enation.app.javashop.model.trade.order.enums.OrderStatusEnum;
import com.enation.app.javashop.service.payment.PaymentBillManager;
import com.enation.app.javashop.service.payment.PaymentPluginManager;
import com.enation.app.javashop.service.payment.RefundManager;
import com.enation.app.javashop.util.BigDecimalUtils;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.sbc.member.client.model.dto.MemberDetailInfoDTO;
import com.ztesoft.zsmart.nros.sbc.order.client.model.param.ReverseOrderDetailParam;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RefundManagerImpl
implements RefundManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private List<PaymentPluginManager> paymentPluginList;
    @Autowired
    private PaymentBillManager paymentBillManager;
    @Autowired
    private PayTemplateInterfaceClient payTemplateInterfaceClient;
    @Autowired
    private Cache cache;
    @Autowired
    private Debugger debugger;
    @Autowired
    @Qualifier(value="tradeDaoSupport")
    private DaoSupport daoSupport;
    @Autowired
    private ZTPaySetting ztPaySetting;
    @Autowired
    private OrderClient orderClient;
    @Autowired
    private GoodsClient goodsClient;
    @Autowired
    private SyncOrderClient syncOrderClient;
    @Autowired
    private MemberInfoRestClient memberInfoRestClient;

    public Map originRefund(String returnTradeNo, String refundSn, Double refundPrice) {
        this.debugger.log("\u53d1\u8d77\u9000\u6b3e");
        PaymentBillDO payBill = this.paymentBillManager.getBillByReturnTradeNo(returnTradeNo);
        if (payBill == null) {
            this.debugger.log("\u7b2c\u4e09\u65b9[" + returnTradeNo + "]\u652f\u4ed8\u8d26\u5355\u627e\u4e0d\u5230");
            throw new ServiceException(PaymentErrorCode.E504.code(), "\u652f\u4ed8\u8d26\u5355\u4e0d\u5b58\u5728");
        }
        PaymentPluginManager plugin = this.findPlugin(payBill.getPaymentPluginId());
        RefundBill refundBill = new RefundBill();
        Map map = (Map)JsonUtil.jsonToObject((String)payBill.getPayConfig(), Map.class);
        List list = (List)map.get("config_list");
        HashMap<String, String> result = new HashMap<String, String>(list.size());
        if (list != null) {
            for (Map item : list) {
                result.put(item.get("name").toString(), item.get("value").toString());
            }
        }
        refundBill.setConfigMap(result);
        refundBill.setRefundPrice(refundPrice);
        refundBill.setRefundSn(refundSn);
        refundBill.setReturnTradeNo(returnTradeNo);
        refundBill.setTradePrice(payBill.getTradePrice());
        this.debugger.log("\u8c03\u8d77[" + plugin + "]");
        boolean refundResult = plugin.onTradeRefund(refundBill);
        this.debugger.log("\u9000\u6b3e\u7ed3\u679c\uff1a" + refundResult);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        if (refundResult) {
            hashMap.put("result", "true");
        } else {
            hashMap.put("result", "false");
            String failKey = "{REFUND_ERROR_MESSAGE}_" + refundBill.getRefundSn();
            hashMap.put("fail_reason", this.cache.get((Object)failKey));
            this.cache.remove((Object)failKey);
        }
        return hashMap;
    }

    public String queryRefundStatus(String returnTradeNo, String refundSn) {
        PaymentBillDO payBill = this.paymentBillManager.getBillByReturnTradeNo(returnTradeNo);
        RefundBill refundBill = new RefundBill();
        Map map = (Map)JsonUtil.jsonToObject((String)payBill.getPayConfig(), Map.class);
        List list = (List)map.get("config_list");
        HashMap<String, String> result = new HashMap<String, String>(list.size());
        if (list != null) {
            for (Map item : list) {
                result.put(item.get("name").toString(), item.get("value").toString());
            }
        }
        refundBill.setConfigMap(result);
        refundBill.setRefundSn(refundSn);
        refundBill.setReturnTradeNo(returnTradeNo);
        PaymentPluginManager plugin = this.findPlugin(payBill.getPaymentPluginId());
        return plugin.queryRefundStatus(refundBill);
    }

    public String refundOrderSync(RefundOrderRespDTO refundResultDTO) {
        this.logger.info("\u540c\u6b65\u552e\u540e\u8ba2\u5355\u4efb\u52a1++++++++++" + JSONUtil.toJsonStr((Object)refundResultDTO));
        String refundSn = refundResultDTO.getRefundUserSerial();
        this.logger.error("\u552e\u540e\u8ba2\u5355\u5355\u53f7==========" + refundSn);
        String sql = "select * from es_refund where sn=?";
        RefundDO refundDO = (RefundDO)this.daoSupport.queryForObject(sql, RefundDO.class, new Object[]{refundSn});
        String serviceSql = "select * from es_as_order where sn=?";
        AfterSaleServiceDO afterSaleServiceDO = (AfterSaleServiceDO)this.daoSupport.queryForObject(serviceSql, AfterSaleServiceDO.class, new Object[]{refundSn});
        OrderDO orderDO = this.orderClient.getOrder(refundDO.getOrderSn());
        String goodsJson = refundDO.getGoodsJson();
        List goodsList = JsonUtil.jsonToList((String)goodsJson, AfterSaleGoodsVO.class);
        ZTReverseOrderParam reverseOrderParam = new ZTReverseOrderParam();
        reverseOrderParam.setMemberId(orderDO.getMemberId() + "");
        reverseOrderParam.setBuyerId(orderDO.getMemberId() + "");
        reverseOrderParam.setOrderNo(orderDO.getZtOrderSn());
        reverseOrderParam.setReverseOrderNo(refundSn);
        reverseOrderParam.setApplyTime(new Date(refundDO.getCreateTime() * 1000L));
        reverseOrderParam.setOutReverseOrderNo(afterSaleServiceDO.getNewOrderSn() == null ? refundSn : afterSaleServiceDO.getNewOrderSn());
        reverseOrderParam.setPaymentTime(new Date());
        reverseOrderParam.setReverseOrderChannel(Integer.valueOf(Integer.parseInt(this.ztPaySetting.getChannelId())));
        reverseOrderParam.setReverseOrderSource(Integer.valueOf(1));
        reverseOrderParam.setReverseOrderType(Integer.valueOf(1));
        reverseOrderParam.setReverseScopeType(Integer.valueOf(2));
        reverseOrderParam.setReverseType(Integer.valueOf(1));
        reverseOrderParam.setStoreName(orderDO.getStoreName());
        reverseOrderParam.setStoreOrgId(String.valueOf(orderDO.getStoreId()));
        reverseOrderParam.setTradeType(Integer.valueOf(140));
        reverseOrderParam.setTradeStatus(Integer.valueOf(1));
        if (orderDO.getOrderStatus().equals(OrderStatusEnum.PAID_OFF.value())) {
            reverseOrderParam.setEvent(Integer.valueOf(12));
        } else {
            reverseOrderParam.setEvent(Integer.valueOf(52));
        }
        ArrayList<ReverseOrderDetailParam> detailLines = new ArrayList<ReverseOrderDetailParam>();
        double points = 0.0;
        double price = 0.0;
        for (AfterSaleGoodsVO afterSaleGoodsVO : goodsList) {
            String itemSql = "select * from es_order_items where order_sn=? and product_id=?";
            OrderItemsDO orderItemsDO = (OrderItemsDO)this.daoSupport.queryForObject(itemSql, OrderItemsDO.class, new Object[]{orderDO.getSn(), afterSaleGoodsVO.getSkuId()});
            ReverseOrderDetailParam reverseOrderDetailParam = new ReverseOrderDetailParam();
            reverseOrderDetailParam.setAccountInventory(Boolean.valueOf(true));
            reverseOrderDetailParam.setActualRefundAmount(BigDecimalUtils.mul((BigDecimal)BigDecimal.valueOf(afterSaleGoodsVO.getPrice()), (BigDecimal)BigDecimal.valueOf(afterSaleGoodsVO.getReturnNum().intValue())));
            reverseOrderDetailParam.setActualRefundPrice(BigDecimal.valueOf(afterSaleGoodsVO.getPrice()));
            ItemChannelFull itemChannelFull = this.goodsClient.getItemCode(orderItemsDO.getItemCode(), orderDO.getStoreId());
            reverseOrderDetailParam.setBunkId(itemChannelFull.getCounterId());
            reverseOrderDetailParam.setBunkCode(itemChannelFull.getCounterCode());
            reverseOrderDetailParam.setBunkName(itemChannelFull.getCounterName());
            reverseOrderDetailParam.setContractId(itemChannelFull.getContractId());
            reverseOrderDetailParam.setContractNo(itemChannelFull.getContractCode());
            reverseOrderDetailParam.setIncludeTaxPurchasingPrice(BigDecimal.valueOf(itemChannelFull.getPurchasePrice()));
            reverseOrderDetailParam.setItemBarCode(itemChannelFull.getBarCode());
            reverseOrderDetailParam.setItemBrandCode(itemChannelFull.getBrandCode());
            reverseOrderDetailParam.setItemBrandName(itemChannelFull.getBrandName());
            reverseOrderDetailParam.setItemCode(itemChannelFull.getItemCode());
            reverseOrderDetailParam.setItemName(itemChannelFull.getItemName());
            reverseOrderDetailParam.setItemOrgId(itemChannelFull.getSaleDepartmentId());
            reverseOrderDetailParam.setItemOrgName(itemChannelFull.getSaleDepartmentName());
            reverseOrderDetailParam.setItemType(itemChannelFull.getItemType());
            reverseOrderDetailParam.setMinimumFlag(Byte.valueOf(itemChannelFull.getGuaranteed() == null ? (byte)0 : itemChannelFull.getGuaranteed().byteValue()));
            reverseOrderDetailParam.setOrderLineNo(orderItemsDO.getItemId().toString());
            BigDecimal originalPrice = itemChannelFull.getRetailPrice() == null ? BigDecimal.ZERO : BigDecimal.valueOf(itemChannelFull.getRetailPrice());
            reverseOrderDetailParam.setOriginalPrice(originalPrice);
            reverseOrderDetailParam.setOriginalSaleAmount(BigDecimalUtils.mul((BigDecimal)originalPrice, (BigDecimal)BigDecimal.valueOf(afterSaleGoodsVO.getReturnNum().intValue())));
            reverseOrderDetailParam.setOriginalSettle(Boolean.valueOf(itemChannelFull.getOriginalSettle() != null && itemChannelFull.getOriginalSettle() != 0));
            reverseOrderDetailParam.setPackageStockNum(BigDecimal.valueOf(afterSaleGoodsVO.getReturnNum().intValue()));
            reverseOrderDetailParam.setPackageUnit(itemChannelFull.getPackageTypeName());
            reverseOrderDetailParam.setPurchaseTaxRate(BigDecimal.valueOf(itemChannelFull.getEntryTaxRate()));
            reverseOrderDetailParam.setReverseOrderNo(refundSn);
            reverseOrderDetailParam.setSalesTaxRate(BigDecimal.valueOf(itemChannelFull.getSalesTaxRate()));
            reverseOrderDetailParam.setStockUnit(itemChannelFull.getPackageTypeName());
            reverseOrderDetailParam.setSupplierCode(itemChannelFull.getSupplierCode());
            reverseOrderDetailParam.setSupplierName(itemChannelFull.getSupplierName());
            reverseOrderDetailParam.setTax(itemChannelFull.getSalesTaxRate() == null ? null : BigDecimal.valueOf(itemChannelFull.getSalesTaxRate()));
            reverseOrderDetailParam.setDeductTax(itemChannelFull.getSalesTaxRate() == null ? null : BigDecimal.valueOf(itemChannelFull.getSalesTaxRate()));
            reverseOrderDetailParam.setPurchaseTaxRate(itemChannelFull.getEntryTaxRate() == null ? null : BigDecimal.valueOf(itemChannelFull.getEntryTaxRate()));
            reverseOrderDetailParam.setSalesTaxRate(itemChannelFull.getSalesTaxRate() == null ? null : BigDecimal.valueOf(itemChannelFull.getSalesTaxRate()));
            double num = CurrencyUtil.div((double)afterSaleGoodsVO.getReturnNum().intValue(), (double)afterSaleGoodsVO.getShipNum().intValue(), (int)4);
            String pointStr = orderItemsDO.getPoints();
            if (StringUtil.notEmpty((String)pointStr)) {
                com.alibaba.fastjson.JSONObject object = JSON.parseObject((String)pointStr);
                Double multiPoint = object.getDouble("multiPoint") == null ? 0.0 : object.getDouble("multiPoint");
                Double growPoint = object.getDouble("growPoint") == null ? 0.0 : object.getDouble("growPoint");
                Double effGrowthPrice = object.getDouble("effGrowthPrice") == null ? 0.0 : object.getDouble("effGrowthPrice");
                Double point = object.getDouble("point") == null ? 0.0 : object.getDouble("point");
                Double memberPoint = object.getDouble("memberPoint") == null ? 0.0 : object.getDouble("memberPoint");
                object.put("multiPoint", (Object)multiPoint);
                object.put("growPoint", (Object)growPoint);
                object.put("effGrowthPrice", (Object)effGrowthPrice);
                object.put("point", (Object)point);
                object.put("memberPoint", (Object)memberPoint);
                com.alibaba.fastjson.JSONObject pointInfo = new com.alibaba.fastjson.JSONObject();
                pointInfo.put("pointInfo", (Object)object);
                pointInfo.put("historyRefundPointInfo", (Object)object);
                pointInfo.put("originalItemPointInfo", (Object)object);
                pointInfo.put("currentRefundPointInfo", (Object)object);
                reverseOrderDetailParam.setExtInfo(pointInfo);
            }
            detailLines.add(reverseOrderDetailParam);
            this.logger.info("\u9000\u6b3e\u79ef\u5206" + orderItemsDO.getPoints());
            String pointJson = StringUtil.notEmpty((String)orderItemsDO.getPoints()) ? orderItemsDO.getPoints() : " {\"point\":0}";
            String point = StringUtil.isEmpty((String)JSONUtil.parseObj((String)pointJson).getStr((Object)"point")) ? "0" : JSONUtil.parseObj((String)pointJson).getStr((Object)"point");
            points = CurrencyUtil.add((double)points, (double)Double.parseDouble(point));
            Double cardPrice = CurrencyUtil.mul((double)(orderItemsDO.getCardPrice() == null ? 0.0 : orderItemsDO.getCardPrice()), (double)num);
            Double couponPrice = CurrencyUtil.mul((double)(orderItemsDO.getCouponPrice() == null ? 0.0 : orderItemsDO.getCouponPrice()), (double)num);
            Double refundPrice = CurrencyUtil.mul((double)(orderItemsDO.getRefundPrice() == null ? 0.0 : orderItemsDO.getRefundPrice()), (double)num);
            double totalPrice = CurrencyUtil.add((double)cardPrice, (double)CurrencyUtil.add((double)couponPrice, (double)refundPrice));
            price = CurrencyUtil.add((double)price, (double)totalPrice);
        }
        this.logger.info("\u8ba2\u5355\u9000\u79ef\u5206:=================" + points);
        reverseOrderParam.setOrderIntegral(BigDecimal.valueOf(points));
        reverseOrderParam.setDetailLines(detailLines);
        ArrayList<ZTOrderPaymentParam> paymentInfos = new ArrayList<ZTOrderPaymentParam>();
        List refundAssemblyAttrList = refundResultDTO.getRefundAssemblyAttr();
        for (RefundAssemblyAttrDTO refundAssemblyAttr : refundAssemblyAttrList) {
            Object payChannelAttr2;
            ZTOrderPaymentParam orderPaymentParam = new ZTOrderPaymentParam();
            orderPaymentParam.setOrderNo(refundSn);
            orderPaymentParam.setPayAppId(this.ztPaySetting.getAppId());
            orderPaymentParam.setPayUserId(orderDO.getMemberId().toString());
            orderPaymentParam.setPaymentAccountType(Integer.valueOf(0));
            String channleSql = "select * from es_payment_channle where store_id=? and payment_id=?";
            PaymentChannleDO paymentChannleDO = (PaymentChannleDO)this.daoSupport.queryForObject(channleSql, PaymentChannleDO.class, new Object[]{orderDO.getStoreId(), refundAssemblyAttr.getPayMethodId()});
            String refundFee = refundAssemblyAttr.getRefundFee();
            if (StringUtil.notEmpty((String)refundFee)) {
                double refund = CurrencyUtil.div((double)Double.parseDouble(refundFee), (double)100.0);
                orderPaymentParam.setPaymentAmount(BigDecimal.valueOf(refund));
                orderPaymentParam.setPaymentChannelId(Long.valueOf(Long.parseLong(paymentChannleDO.getChannleId())));
            }
            List payChannelAttrList = this.getChannle(orderDO.getStoreId().toString());
            for (Object payChannelAttr2 : payChannelAttrList) {
                if (!payChannelAttr2.getPayChannelId().equals(paymentChannleDO.getChannleId())) continue;
                orderPaymentParam.setPaymentChannelName(payChannelAttr2.getPayChannelName());
            }
            orderPaymentParam.setPaymentCode(refundAssemblyAttr.getPayMethodId().toString());
            orderPaymentParam.setPaymentDetail(orderDO.getPaymentMethodName() == null ? "\u5176\u4ed6\u652f\u4ed8" : orderDO.getPaymentMethodName());
            orderPaymentParam.setPaymentDirection(Integer.valueOf(2));
            List payChannelMethodDetailAttrList = this.getPaymentId(paymentChannleDO.getChannleId());
            payChannelAttr2 = payChannelMethodDetailAttrList.iterator();
            while (payChannelAttr2.hasNext()) {
                PayChannelMethodDetailAttr payChannelMethodDetailAttr = (PayChannelMethodDetailAttr)payChannelAttr2.next();
                if (!payChannelMethodDetailAttr.getPayMethodId().equals(refundAssemblyAttr.getPayMethodId().toString())) continue;
                orderPaymentParam.setPaymentMethodTypeId(payChannelMethodDetailAttr.getPayMethodTypeId());
                orderPaymentParam.setPaymentMethodTypeName(payChannelMethodDetailAttr.getPayMethodTypeName());
                orderPaymentParam.setPaymentName(payChannelMethodDetailAttr.getPayMethodName());
            }
            if (StringUtil.notEmpty((String)refundAssemblyAttr.getPayTicketNumber())) {
                orderPaymentParam.setPaymentCardNo(refundAssemblyAttr.getPayTicketNumber());
            }
            orderPaymentParam.setPaymentNo(refundAssemblyAttr.getRefundChannelSerial());
            orderPaymentParam.setPaymentSerialNumber(refundAssemblyAttr.getOperSerialId());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            orderPaymentParam.setPaymentTime(format.format(new Date()));
            orderPaymentParam.setPaymentOrderSerialNumber(refundResultDTO.getOperSerialId());
            paymentInfos.add(orderPaymentParam);
        }
        reverseOrderParam.setActualAmont(BigDecimal.valueOf(price));
        reverseOrderParam.setApplyAmount(BigDecimal.valueOf(price));
        reverseOrderParam.setPaymentInfos(paymentInfos);
        ResponseMsg byMember = this.memberInfoRestClient.getDetailByMemberId(orderDO.getMemberId());
        reverseOrderParam.setLevelId(Integer.valueOf(((MemberDetailInfoDTO)byMember.getData()).getLevelId().intValue()));
        reverseOrderParam.setLevelName(((MemberDetailInfoDTO)byMember.getData()).getLevelName());
        this.syncOrderClient.syncRefundOrder(reverseOrderParam);
        return null;
    }

    private PaymentPluginManager findPlugin(String pluginId) {
        for (PaymentPluginManager plugin : this.paymentPluginList) {
            if (!plugin.getPluginId().equals(pluginId)) continue;
            return plugin;
        }
        return null;
    }

    public List<PayChannelAttr> getChannle(String storeId) {
        OperAttrStruct operAttrStruct = new OperAttrStruct();
        operAttrStruct.setOperOrgId(Integer.valueOf(1));
        operAttrStruct.setOperPost("1");
        operAttrStruct.setOperTime(DateUtil.getNowDay());
        operAttrStruct.setStaffId(Integer.valueOf(1));
        operAttrStruct.setStaffName("\u6d4b\u8bd5");
        ChannelRelVO channelRelVO = new ChannelRelVO();
        channelRelVO.setOperAttrStruct(operAttrStruct);
        channelRelVO.setAppId(this.ztPaySetting.getAppId());
        channelRelVO.setPracticalShopId(storeId.toString());
        channelRelVO.setSignType("MD5");
        channelRelVO.setStatusCd("1");
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("appId", this.ztPaySetting.getAppId());
        parameters.put("practicalShopId", storeId);
        parameters.put("signType", "MD5");
        parameters.put("statusCd", "1");
        String sign = StringUtil.createSign(parameters, (String)this.ztPaySetting.getKey());
        channelRelVO.setSign(sign);
        String result = this.payTemplateInterfaceClient.getOrderChanl(channelRelVO);
        System.out.println("\u4e2d\u53f0\u83b7\u53d6\u6e20\u9053" + result);
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        JSONArray jsonArray = jsonObject.getJSONArray("payChannelAttr");
        List payChannelAttrList = JsonUtil.jsonToList((String)jsonArray.toString(), PayChannelAttr.class);
        return payChannelAttrList;
    }

    public List<PayChannelMethodDetailAttr> getPaymentId(String channelId) {
        OperAttrStruct operAttrStruct = new OperAttrStruct();
        operAttrStruct.setOperOrgId(Integer.valueOf(1));
        operAttrStruct.setOperPost("1");
        operAttrStruct.setOperTime(DateUtil.getNowDay());
        operAttrStruct.setStaffId(Integer.valueOf(1));
        operAttrStruct.setStaffName("\u5fae\u5546\u57ce");
        ChannelMethodRelVO channelMethodRelVO = new ChannelMethodRelVO();
        channelMethodRelVO.setOperAttrStruct(operAttrStruct);
        channelMethodRelVO.setPayChannelId(channelId);
        channelMethodRelVO.setStatusCd("1");
        channelMethodRelVO.setSignType("MD5");
        TreeMap<String, String> parameMap = new TreeMap<String, String>();
        parameMap.put("payChannelId", channelId);
        parameMap.put("signType", "MD5");
        parameMap.put("statusCd", "1");
        String signStr = StringUtil.createSign(parameMap, (String)this.ztPaySetting.getKey());
        channelMethodRelVO.setSign(signStr);
        String resultPay = this.payTemplateInterfaceClient.getOrderChanlPay(channelMethodRelVO);
        System.out.println("\u4e2d\u53f0\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f" + resultPay);
        JSONObject jsonObjectPay = JSONObject.fromObject((Object)resultPay);
        JSONArray jsonArrayPay = jsonObjectPay.getJSONArray("payChannelMethodDetailAttr");
        List payChannelMethodDetailAttrs = JsonUtil.jsonToList((String)jsonArrayPay.toString(), PayChannelMethodDetailAttr.class);
        return payChannelMethodDetailAttrs;
    }
}

