/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.database.Page;
import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.util.BeanUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.CachePrefix;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.payment.dos.PaymentChannleDO;
import com.enation.app.javashop.model.payment.dos.PaymentMethodDO;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.vo.ClientConfig;
import com.enation.app.javashop.model.payment.vo.PayConfigItem;
import com.enation.app.javashop.model.payment.vo.PaymentChannleVO;
import com.enation.app.javashop.model.payment.vo.PaymentMethodVO;
import com.enation.app.javashop.model.payment.vo.PaymentPluginVO;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import com.enation.app.javashop.service.payment.PaymentPluginManager;
import com.enation.app.javashop.service.payment.impl.PaymentVoConverter;
import com.taobao.txc.client.aop.annotation.Propagation;
import com.taobao.txc.client.aop.annotation.TxcTransaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaymentMethodManagerImpl
implements PaymentMethodManager {
    @Autowired
    @Qualifier(value="tradeDaoSupport")
    private DaoSupport daoSupport;
    @Autowired
    private List<PaymentPluginManager> paymentPluginList;
    @Autowired
    private Cache cache;

    public Page list(int page, int pageSize) {
        ArrayList<PaymentPluginVO> resultList = new ArrayList<PaymentPluginVO>();
        String sql = "select * from es_payment_method ";
        List list = this.daoSupport.queryForList(sql, PaymentMethodDO.class, new Object[0]);
        HashMap<String, PaymentMethodDO> map = new HashMap<String, PaymentMethodDO>(list.size());
        for (PaymentMethodDO payment : list) {
            map.put(payment.getPluginId(), payment);
        }
        for (PaymentPluginManager plugin : this.paymentPluginList) {
            PaymentMethodDO payment = (PaymentMethodDO)map.get(plugin.getPluginId());
            PaymentPluginVO result = null;
            result = payment != null ? new PaymentPluginVO(payment) : PaymentVoConverter.toValidatorPlatformVO((PaymentPluginManager)plugin);
            resultList.add(result);
        }
        Integer size = resultList.size();
        return new Page(Integer.valueOf(page), Long.valueOf(size.longValue()), Integer.valueOf(pageSize), resultList);
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public PaymentMethodDO add(PaymentPluginVO paymentMethod, String paymentPluginId) {
        Object keys;
        String sql = "delete from es_payment_method where plugin_id = ? ";
        this.daoSupport.execute(sql, new Object[]{paymentPluginId});
        PaymentPluginManager paymentPlugin = this.findPlugin(paymentPluginId);
        if (paymentPlugin == null) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u63d2\u4ef6id\u4e0d\u6b63\u786e");
        }
        paymentMethod.setMethodName(paymentPlugin.getPluginName());
        paymentMethod.setPluginId(paymentPluginId);
        List clients = paymentMethod.getEnableClient();
        HashMap<String, ClientConfig> map = new HashMap<String, ClientConfig>(16);
        for (ClientConfig client : clients) {
            Object keyStr = client.getKey();
            keyStr = ((String)keyStr).replace("amp;", "");
            keys = ((String)keyStr).split("&");
            for (String string : keys) {
                map.put(string, client);
            }
        }
        List needClients = paymentPlugin.definitionClientConfig();
        HashMap<String, String> jsonMap = new HashMap<String, String>(16);
        for (ClientConfig clientConfig : needClients) {
            String[] keys2;
            String keyStr = clientConfig.getKey();
            for (String key : keys2 = keyStr.split("&")) {
                ClientConfig client = (ClientConfig)map.get(key);
                if (client == null) {
                    throw new ServiceException(PaymentErrorCode.E501.code(), "\u7f3a\u5c11" + clientConfig.getName() + "\u76f8\u5173\u914d\u7f6e");
                }
                Integer open = client.getIsOpen();
                clientConfig.setIsOpen(client.getIsOpen());
                if (open == 0) {
                    jsonMap.put(StringUtil.lowerUpperCaseColumn((String)key), JsonUtil.objectToJson((Object)clientConfig));
                    continue;
                }
                List list = client.getConfigList();
                if (list == null) {
                    throw new ServiceException(PaymentErrorCode.E501.code(), clientConfig.getName() + "\u7684\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
                }
                HashMap<String, String> valueMap = new HashMap<String, String>(list.size());
                for (PayConfigItem item : list) {
                    valueMap.put(item.getName(), item.getValue());
                }
                List configList = clientConfig.getConfigList();
                for (PayConfigItem item : configList) {
                    String value = (String)valueMap.get(item.getName());
                    if (StringUtil.isEmpty((String)value)) {
                        throw new ServiceException(PaymentErrorCode.E501.code(), clientConfig.getName() + "\u7684" + item.getText() + "\u5fc5\u586b");
                    }
                    item.setValue(value);
                }
                clientConfig.setConfigList(configList);
                jsonMap.put(StringUtil.lowerUpperCaseColumn((String)key), JsonUtil.objectToJson((Object)clientConfig));
            }
        }
        PaymentMethodDO payment = new PaymentMethodDO();
        BeanUtil.copyPropertiesInclude(jsonMap, (Object)payment);
        BeanUtil.copyProperties((Object)paymentMethod, (Object)payment);
        this.daoSupport.insert((Object)payment);
        payment.setMethodId(this.daoSupport.getLastId(""));
        keys = new ArrayList();
        for (String string : ClientType.values()) {
            keys.add(CachePrefix.PAYMENT_CONFIG.getPrefix() + string.getDbColumn() + paymentPluginId);
        }
        this.cache.multiDel((Collection)keys);
        return payment;
    }

    public PaymentPluginVO getByPlugin(String pluginId) {
        String miniConfig;
        String appNativeConfig;
        String appReactConfig;
        String wapConfig;
        PaymentMethodDO paymentMethod = this.getByPluginId(pluginId);
        if (paymentMethod == null) {
            PaymentPluginManager plugin = this.findPlugin(pluginId);
            if (plugin == null) {
                throw new ServiceException(PaymentErrorCode.E501.code(), "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728");
            }
            PaymentPluginVO payment = PaymentVoConverter.toValidatorPlatformVO((PaymentPluginManager)plugin);
            payment.setEnableClient(plugin.definitionClientConfig());
            return payment;
        }
        HashMap<String, ClientConfig> map = new HashMap<String, ClientConfig>(16);
        String pcConfig = paymentMethod.getPcConfig();
        if (pcConfig != null) {
            ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)pcConfig, ClientConfig.class);
            map.put(config.getKey(), config);
        }
        if ((wapConfig = paymentMethod.getWapConfig()) != null) {
            ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)wapConfig, ClientConfig.class);
            map.put(config.getKey(), config);
        }
        if ((appReactConfig = paymentMethod.getAppReactConfig()) != null) {
            ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)appReactConfig, ClientConfig.class);
            map.put(config.getKey(), config);
        }
        if ((appNativeConfig = paymentMethod.getAppNativeConfig()) != null) {
            ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)appNativeConfig, ClientConfig.class);
            map.put(config.getKey(), config);
        }
        if ((miniConfig = paymentMethod.getMiniConfig()) != null) {
            ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)miniConfig, ClientConfig.class);
            map.put(config.getKey(), config);
        }
        PaymentPluginVO pluginVO = new PaymentPluginVO();
        BeanUtil.copyProperties((Object)paymentMethod, (Object)pluginVO);
        ArrayList clientConfigs = new ArrayList();
        for (String key : map.keySet()) {
            clientConfigs.add(map.get(key));
        }
        pluginVO.setEnableClient(clientConfigs);
        return pluginVO;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public PaymentMethodDO edit(PaymentMethodDO paymentMethod, Long id) {
        PaymentMethodDO method = (PaymentMethodDO)this.daoSupport.queryForObject(PaymentMethodDO.class, id);
        if (method == null) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728");
        }
        this.daoSupport.update((Object)paymentMethod, id);
        ArrayList<String> keys = new ArrayList<String>();
        for (ClientType clientType : ClientType.values()) {
            keys.add(CachePrefix.PAYMENT_CONFIG.getPrefix() + clientType.getDbColumn() + id);
        }
        this.cache.multiDel(keys);
        return paymentMethod;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public void delete(Long id) {
        this.daoSupport.delete(PaymentMethodDO.class, id);
        ArrayList<String> keys = new ArrayList<String>();
        for (ClientType clientType : ClientType.values()) {
            keys.add(CachePrefix.PAYMENT_CONFIG.getPrefix() + clientType.getDbColumn() + id);
        }
        this.cache.multiDel(keys);
    }

    public PaymentMethodDO getByPluginId(String pluginId) {
        if (pluginId == null) {
            return null;
        }
        String sql = "select * from es_payment_method where plugin_id = ?";
        return (PaymentMethodDO)this.daoSupport.queryForObject(sql, PaymentMethodDO.class, new Object[]{pluginId});
    }

    public List<PaymentMethodVO> queryMethodByClient(String clientType) {
        ArrayList<PaymentMethodVO> resList = new ArrayList<PaymentMethodVO>();
        String sql = "select * from es_payment_method ";
        List list = this.daoSupport.queryForList(sql, new Object[0]);
        if (list != null) {
            String column = ClientType.valueOf((String)clientType).getDbColumn();
            for (Map map : list) {
                String config;
                JSONObject json;
                String open;
                if (map.get(column) == null || !"1".equals(open = (json = JSONObject.fromObject((Object)(config = map.get(column).toString()))).get("is_open").toString())) continue;
                PaymentMethodVO payment = new PaymentMethodVO();
                payment.setPluginId(map.get("plugin_id").toString());
                payment.setMethodName(map.get("method_name").toString());
                payment.setIsRetrace(Integer.valueOf(Integer.parseInt(map.get("is_retrace").toString())));
                if (map.get("image") != null) {
                    payment.setImage(map.get("image").toString());
                }
                resList.add(payment);
            }
        }
        return resList;
    }

    public Map<String, String> getConfig(String clientType, String paymentMethodId) {
        this.cache.remove((Object)(CachePrefix.PAYMENT_CONFIG.getPrefix() + clientType + paymentMethodId));
        String config = (String)this.cache.get((Object)(CachePrefix.PAYMENT_CONFIG.getPrefix() + clientType + paymentMethodId));
        System.out.println(CachePrefix.PAYMENT_CONFIG.getPrefix() + clientType + paymentMethodId);
        if (config == null) {
            config = this.daoSupport.queryForString("select " + clientType + " from es_payment_method where plugin_id=?", new Object[]{paymentMethodId});
            this.cache.put((Object)(CachePrefix.PAYMENT_CONFIG.getPrefix() + clientType + paymentMethodId), (Object)config);
        }
        if (StringUtil.isEmpty((String)config)) {
            return new HashMap<String, String>(16);
        }
        Map map = (Map)JsonUtil.jsonToObject((String)config, Map.class);
        List list = (List)map.get("config_list");
        if (!"1".equals(map.get("is_open").toString())) {
            throw new ServiceException(PaymentErrorCode.E502.code(), "\u652f\u4ed8\u65b9\u5f0f\u672a\u5f00\u542f");
        }
        HashMap<String, String> result = new HashMap<String, String>(list.size());
        if (list != null) {
            for (Map item : list) {
                result.put(item.get("name").toString(), item.get("value").toString());
            }
        }
        return result;
    }

    private PaymentPluginManager findPlugin(String pluginId) {
        for (PaymentPluginManager plugin : this.paymentPluginList) {
            if (!plugin.getPluginId().equals(pluginId)) continue;
            return plugin;
        }
        return null;
    }

    public List<PaymentChannleDO> paymentSave(List<PaymentChannleVO> paymentChannleVOList) {
        ArrayList<PaymentChannleDO> list = new ArrayList<PaymentChannleDO>();
        for (PaymentChannleVO paymentChannleVO : paymentChannleVOList) {
            String sql = "select * from es_payment_channle where store_id=? and plugin_id =? ";
            PaymentChannleDO paymentChannleDO = (PaymentChannleDO)this.daoSupport.queryForObject(sql, PaymentChannleDO.class, new Object[]{paymentChannleVO.getStoreId(), paymentChannleVO.getPluginId()});
            if (paymentChannleDO == null) {
                paymentChannleDO = new PaymentChannleDO();
                paymentChannleDO.setStoreId(paymentChannleVO.getStoreId());
                paymentChannleDO.setChannleId(paymentChannleVO.getChannleId());
                paymentChannleDO.setPaymentId(paymentChannleVO.getPaymentId());
                paymentChannleDO.setPluginId(paymentChannleVO.getPluginId());
                this.daoSupport.insert((Object)paymentChannleDO);
                paymentChannleDO.setId(this.daoSupport.getLastId("es_payment_channle"));
                list.add(paymentChannleDO);
                continue;
            }
            paymentChannleDO.setStoreId(paymentChannleVO.getStoreId());
            paymentChannleDO.setChannleId(paymentChannleVO.getChannleId());
            paymentChannleDO.setPaymentId(paymentChannleVO.getPaymentId());
            paymentChannleDO.setPluginId(paymentChannleVO.getPluginId());
            this.daoSupport.update((Object)paymentChannleDO, paymentChannleDO.getId());
            list.add(paymentChannleDO);
        }
        return list;
    }

    public PaymentChannleDO getInfo(Long storeId, String pluginId) {
        String sql = "select * from es_payment_channle where store_id=? and plugin_id =? ";
        return (PaymentChannleDO)this.daoSupport.queryForObject(sql, PaymentChannleDO.class, new Object[]{storeId, pluginId});
    }
}

