/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import cn.hutool.json.JSONUtil;
import com.enation.app.javashop.client.member.MemberClient;
import com.enation.app.javashop.client.member.ShopClient;
import com.enation.app.javashop.client.promotion.PayTemplateInterfaceClient;
import com.enation.app.javashop.client.promotion.PromotionActiveClient;
import com.enation.app.javashop.client.system.SmsClient;
import com.enation.app.javashop.client.trade.OrderClient;
import com.enation.app.javashop.framework.JavashopConfig;
import com.enation.app.javashop.framework.cache.Cache;
import com.enation.app.javashop.framework.context.request.ThreadContextHolder;
import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.DateUtil;
import com.enation.app.javashop.framework.util.HttpUtils;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.Sha256;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.CachePrefix;
import com.enation.app.javashop.model.base.DomainSettings;
import com.enation.app.javashop.model.base.SceneType;
import com.enation.app.javashop.model.base.ZTPaySetting;
import com.enation.app.javashop.model.errorcode.MemberErrorCode;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.errorcode.TradeErrorCode;
import com.enation.app.javashop.model.member.dos.Member;
import com.enation.app.javashop.model.member.vo.Auth2Token;
import com.enation.app.javashop.model.payment.dos.PaymentBillDO;
import com.enation.app.javashop.model.payment.dos.PaymentChannleDO;
import com.enation.app.javashop.model.payment.dos.PaymentMethodDO;
import com.enation.app.javashop.model.payment.dto.PayParam;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.enums.UnionAffairsConfigItem;
import com.enation.app.javashop.model.payment.vo.ChannelMethodRelVO;
import com.enation.app.javashop.model.payment.vo.ClientConfig;
import com.enation.app.javashop.model.payment.vo.Form;
import com.enation.app.javashop.model.payment.vo.FormItem;
import com.enation.app.javashop.model.payment.vo.OperAttrStruct;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.payment.vo.PayChannelMethodDetailAttr;
import com.enation.app.javashop.model.payment.vo.PayConfigItem;
import com.enation.app.javashop.model.payment.vo.PaymentMethodVO;
import com.enation.app.javashop.model.promotion.presale.PresaleBuyGoodsDO;
import com.enation.app.javashop.model.shop.vo.ShopVO;
import com.enation.app.javashop.model.trade.order.dos.OrderDO;
import com.enation.app.javashop.model.trade.order.dos.OrderItemsDO;
import com.enation.app.javashop.model.trade.order.dos.TradeDO;
import com.enation.app.javashop.model.trade.order.dto.OrderDetailDTO;
import com.enation.app.javashop.model.trade.order.enums.OrderStatusEnum;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.OrderManager;
import com.enation.app.javashop.service.payment.PaymentBillManager;
import com.enation.app.javashop.service.payment.PaymentManager;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import com.enation.app.javashop.service.payment.PaymentPluginManager;
import com.enation.app.javashop.service.payment.TradeQueryManager;
import com.enation.app.javashop.service.payment.impl.PaymentManagerImpl;
import com.enation.app.javashop.util.BigDecimalUtils;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CardPriceDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.CouponPriceDTO;
import com.ztesoft.zsmart.nros.sbc.promotion.client.model.dto.ShareItemShopDto;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PaymentManagerImpl
implements PaymentManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="tradeDaoSupport")
    private DaoSupport daoSupport;
    @Autowired
    private PaymentBillManager paymentBillManager;
    @Autowired
    private List<PaymentPluginManager> paymentPluginList;
    @Autowired
    private Debugger debugger;
    @Autowired
    private PaymentMethodManager paymentMethodManager;
    @Autowired
    private OrderManager orderManager;
    @Autowired
    private TradeQueryManager tradeQueryManager;
    @Autowired
    private Cache cache;
    @Autowired
    private ShopClient shopClient;
    @Autowired
    private DomainSettings domainSettings;
    @Autowired
    private JavashopConfig javashopConfig;
    @Autowired
    private MemberClient memberClient;
    @Autowired
    private PayTemplateInterfaceClient payTemplateInterfaceClient;
    @Autowired
    private ZTPaySetting ztPaySetting;
    @Autowired
    private PromotionActiveClient promotionActiveClient;
    @Autowired
    private OrderClient orderClient;
    @Autowired
    private SmsClient smsClient;

    public static boolean checkSign(JSONObject data, String sign, String secret) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Object key : data.keySet()) {
            String value = data.optString((String)key);
            if (value == null || "".equals(value) || "sign".equals(key)) continue;
            map.put((String)key, value);
        }
        StringBuffer buffer = new StringBuffer();
        for (String key : map.keySet()) {
            if (map.get(key) == null || "".equals(map.get(key))) continue;
            if (buffer.length() == 0) {
                buffer.append(key + "=" + (String)map.get(key));
                continue;
            }
            buffer.append("&" + key + "=" + (String)map.get(key));
        }
        String localMac = Sha256.getSHA256((String)(buffer.toString() + secret));
        return sign.equalsIgnoreCase(localMac);
    }

    public static String getnonce() {
        int a = (int)(1.0 + Math.random() * 10000.0);
        String nonce = String.valueOf(a);
        return nonce;
    }

    public Map pay(PayBill bill) {
        PaymentPluginManager paymentPlugin = this.findPlugin(bill.getPluginId());
        this.logger.debug("\u5f00\u59cb\u8c03\u8d77\u652f\u4ed8\u63d2\u4ef6\uff1a" + bill.getPluginId());
        this.debugger.log("\u5f00\u59cb\u8c03\u8d77\u652f\u4ed8\u63d2\u4ef6\uff1a" + bill.getPluginId());
        return paymentPlugin.pay(bill);
    }

    public String payCallback(String paymentPluginId, ClientType clientType) {
        PaymentPluginManager plugin = this.findPlugin(paymentPluginId);
        if (plugin != null) {
            return plugin.onCallback(clientType);
        }
        return "fail";
    }

    public List<PaymentMethodVO> queryPayments(String clientType) {
        List list = this.paymentMethodManager.queryMethodByClient(clientType);
        return list;
    }

    public void payReturn(TradeTypeEnum tradeType, String paymentPluginId) {
        PaymentPluginManager plugin = this.findPlugin(paymentPluginId);
        if (plugin != null) {
            plugin.onReturn(tradeType);
        }
    }

    public String queryResult(String subSn, String serviceType) {
        PaymentBillDO paymentBill = this.paymentBillManager.getBySubSnAndServiceType(subSn, serviceType);
        if (paymentBill.getIsPay() == 1) {
            return "success";
        }
        PaymentPluginManager plugin = this.findPlugin(paymentBill.getPaymentPluginId());
        Map map = (Map)JsonUtil.jsonToObject((String)paymentBill.getPayConfig(), Map.class);
        List list = (List)map.get("config_list");
        HashMap<String, String> result = new HashMap<String, String>(list.size());
        if (list != null) {
            for (Map item : list) {
                result.put(item.get("name").toString(), item.get("value").toString());
            }
        }
        return plugin.onQuery(paymentBill.getBillSn(), result);
    }

    public Map pay(PayParam param) {
        PaymentMethodDO paymentMethod = this.paymentMethodManager.getByPluginId(param.getPaymentPluginId());
        PaymentBillDO tempBill = new PaymentBillDO(param.getSn(), param.getPrice(), param.getTradeType());
        tempBill.setPaymentPluginId(paymentMethod.getPluginId());
        tempBill.setPaymentName(paymentMethod.getMethodName());
        ClientType clientType = ClientType.valueOf((String)param.getClientType());
        switch (1.$SwitchMap$com$enation$app$javashop$model$payment$enums$ClientType[clientType.ordinal()]) {
            case 1: {
                tempBill.setPayConfig(paymentMethod.getPcConfig());
                break;
            }
            case 2: {
                tempBill.setPayConfig(paymentMethod.getWapConfig());
                break;
            }
            case 3: {
                tempBill.setPayConfig(paymentMethod.getAppNativeConfig());
                break;
            }
            case 4: {
                tempBill.setPayConfig(paymentMethod.getAppReactConfig());
                break;
            }
            case 5: {
                tempBill.setPayConfig(paymentMethod.getMiniConfig());
                break;
            }
        }
        PayBill bill = this.paymentBillManager.add(tempBill);
        bill.setPayMode(param.getPayMode());
        bill.setClientType(ClientType.valueOf((String)param.getClientType()));
        Map map = this.pay(bill);
        map.put("payment_method", paymentMethod.getMethodName());
        return map;
    }

    public Form miniUnionPay(PayParam param, String uuid) {
        List itemList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)param.getItemList())) {
            itemList = JsonUtil.jsonToList((String)param.getItemList(), ShareItemShopDto.class);
        }
        boolean isLegitimate = true;
        boolean isEnd = true;
        isLegitimate = param.getTradeType().equals(TradeTypeEnum.ORDER.name()) ? this.checkStatus(param.getSn(), TradeTypeEnum.ORDER, Integer.valueOf(0)) : this.checkStatus(param.getSn(), TradeTypeEnum.TRADE, Integer.valueOf(0));
        if (!isLegitimate) {
            throw new ServiceException(PaymentErrorCode.E506.code(), "\u8be5\u4ea4\u6613\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u652f\u4ed8");
        }
        if (!isEnd) {
            throw new ServiceException(PaymentErrorCode.E506.code(), "\u4fc3\u9500\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        String sql = "";
        String updateSql = "";
        if (TradeTypeEnum.TRADE.name().equals(param.getTradeType())) {
            sql = "select total_price as order_price from es_trade  where trade_sn = ?";
            updateSql = "update es_order set payment_plugin_id = ?,payment_method_name = ? where trade_sn = ?";
        } else {
            sql = "select order_price  from es_order  where sn = ?";
            updateSql = "update es_order  set payment_plugin_id = ?,payment_method_name = ? where sn = ?";
        }
        PayBill bill = (PayBill)this.daoSupport.queryForObject(sql, PayBill.class, new Object[]{param.getSn()});
        if (bill == null) {
            throw new ServiceException(PaymentErrorCode.E500.code(), "\u8be5\u4ea4\u6613\u4e0d\u5b58\u5728,\u4e0d\u80fd\u652f\u4ed8");
        }
        BigDecimal discountPrice = BigDecimal.valueOf(0L);
        if (itemList != null) {
            for (ShareItemShopDto shareItemDTO : itemList) {
                BigDecimal couponPrice = shareItemDTO.getCouponPriceDTOList().stream().map(CouponPriceDTO::getCouponPrice).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal cardPrice = shareItemDTO.getCardPriceList().stream().map(CardPriceDTO::getCardPrice).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                discountPrice = BigDecimalUtils.add((BigDecimal)discountPrice, (BigDecimal)BigDecimalUtils.add((BigDecimal)couponPrice, (BigDecimal)cardPrice));
            }
        }
        BigDecimal orderPrice = BigDecimal.valueOf(0L);
        if (discountPrice.compareTo(BigDecimal.valueOf(bill.getOrderPrice())) <= 0) {
            orderPrice = BigDecimal.valueOf(bill.getOrderPrice()).subtract(discountPrice);
        }
        bill.setOrderPrice(Double.valueOf(Double.parseDouble(orderPrice.toString())));
        bill.setPayMode(param.getPayMode());
        bill.setTradeType(TradeTypeEnum.valueOf((String)param.getTradeType()));
        bill.setClientType(ClientType.valueOf((String)param.getClientType()));
        PaymentMethodDO paymentMethod = this.paymentMethodManager.getByPluginId(param.getPaymentPluginId());
        if (paymentMethod == null) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u672a\u627e\u5230\u76f8\u5e94\u7684\u652f\u4ed8\u65b9\u5f0f[" + param.getPaymentPluginId() + "]");
        }
        String pcConfig = paymentMethod.getPcConfig();
        ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)pcConfig, ClientConfig.class);
        List payConfigItemList = config.getConfigList();
        String msgId = "";
        String mId = "";
        String tId = "";
        String url = "";
        String secret = "";
        String appId = "";
        for (PayConfigItem payConfigItem : payConfigItemList) {
            if (UnionAffairsConfigItem.msg_id.value().equals(payConfigItem.getName())) {
                msgId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.m_id.value().equals(payConfigItem.getName())) {
                mId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.t_id.value().equals(payConfigItem.getName())) {
                tId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.url.value().equals(payConfigItem.getName())) {
                url = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.secret.value().equals(payConfigItem.getName())) {
                secret = payConfigItem.getValue();
            }
            if (!UnionAffairsConfigItem.app_id.value().equals(payConfigItem.getName())) continue;
            appId = payConfigItem.getValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(msgId);
        stringBuffer.append(DateUtil.format());
        int rand = (int)((Math.random() * 9.0 + 1.0) * 1000000.0);
        stringBuffer.append(rand);
        String outTradeNo = stringBuffer.toString();
        PaymentBillDO paymentBill = new PaymentBillDO(param.getSn(), outTradeNo, null, Integer.valueOf(0), bill.getTradeType().name(), paymentMethod.getMethodName(), bill.getOrderPrice(), paymentMethod.getPluginId());
        switch (1.$SwitchMap$com$enation$app$javashop$model$payment$enums$ClientType[ClientType.valueOf((String)param.getClientType()).ordinal()]) {
            case 1: {
                paymentBill.setPayConfig(paymentMethod.getPcConfig());
                break;
            }
            case 2: {
                paymentBill.setPayConfig(paymentMethod.getWapConfig());
                break;
            }
            case 3: {
                paymentBill.setPayConfig(paymentMethod.getAppNativeConfig());
                break;
            }
            case 4: {
                paymentBill.setPayConfig(paymentMethod.getAppReactConfig());
                break;
            }
            case 5: {
                paymentBill.setPayConfig(paymentMethod.getMiniConfig());
                break;
            }
        }
        this.paymentBillManager.add(paymentBill);
        this.daoSupport.execute(updateSql, new Object[]{paymentMethod.getPluginId(), paymentMethod.getMethodName(), param.getSn()});
        bill.setBillSn(outTradeNo);
        ArrayList<Object> subOrder = new ArrayList<Object>();
        if (bill.getTradeType().equals((Object)TradeTypeEnum.TRADE)) {
            List orderList = this.orderManager.getOrderByTradeSn(param.getSn());
            for (OrderDetailDTO orderDetailDTO : orderList) {
                List orderItemsDOList = this.orderClient.orderItems(orderDetailDTO.getSn());
                ArrayList orderItemList = new ArrayList();
                Double paymentPriceTotal = 0.0;
                for (OrderItemsDO skuGoodsVO : orderItemsDOList) {
                    for (ShareItemShopDto shareItemDTO : itemList) {
                        if (!shareItemDTO.getItemCode().equals(skuGoodsVO.getItemCode()) || !orderDetailDTO.getSn().equals(shareItemDTO.getOrderLineNo())) continue;
                        orderItemList.add(shareItemDTO);
                        double paymentPrice = shareItemDTO.getPaymentPriceDTOList().stream().mapToDouble(paymentPriceDTO -> paymentPriceDTO.getPaymentTypePrice().doubleValue()).sum();
                        paymentPriceTotal = CurrencyUtil.add((double)paymentPriceTotal, (double)paymentPrice);
                    }
                }
                HashMap map2 = new HashMap();
                ShopVO shopVO = this.shopClient.getShop(orderDetailDTO.getSellerId());
                if (StringUtil.isEmpty((String)shopVO.getmId())) {
                    throw new ServiceException(PaymentErrorCode.E506.code(), "\u5b58\u5728\u5546\u5bb6\u6682\u4e0d\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\uff01");
                }
                map2.put("mid", shopVO.getmId());
                map2.put("totalAmount", CurrencyUtil.mul((double)paymentPriceTotal, (double)100.0).intValue() + "");
                subOrder.add(map2);
                this.cache.put((Object)(CachePrefix.ORDER_PROMOTION.getPrefix() + orderDetailDTO.getSn()), (Object)JsonUtil.objectToJson((Object)orderItemList));
            }
        } else {
            OrderDO order = this.orderManager.getModel(param.getSn());
            List orderItemsDOList = this.orderClient.orderItems(order.getSn());
            ArrayList<ShareItemShopDto> orderItemList = new ArrayList<ShareItemShopDto>();
            Double paymentPriceTotal = 0.0;
            for (OrderItemsDO skuGoodsVO : orderItemsDOList) {
                for (Object shareItemDTO : itemList) {
                    if (!shareItemDTO.getItemCode().equals(skuGoodsVO.getItemCode())) continue;
                    orderItemList.add((ShareItemShopDto)shareItemDTO);
                    double paymentPrice = shareItemDTO.getPaymentPriceDTOList().stream().mapToDouble(paymentPriceDTO -> paymentPriceDTO.getPaymentTypePrice().doubleValue()).sum();
                    paymentPriceTotal = CurrencyUtil.add((double)paymentPriceTotal, (double)paymentPrice);
                }
            }
            HashMap<String, String> map3 = new HashMap<String, String>();
            ShopVO shopVO = this.shopClient.getShop(order.getSellerId());
            if (StringUtil.isEmpty((String)shopVO.getmId())) {
                throw new ServiceException(PaymentErrorCode.E506.code(), "\u5b58\u5728\u5546\u5bb6\u6682\u4e0d\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\uff01");
            }
            map3.put("mid", shopVO.getmId());
            map3.put("totalAmount", CurrencyUtil.mul((double)paymentPriceTotal, (double)100.0).intValue() + "");
            this.logger.info("\u6bcf\u7b14\u91d1\u989d:" + paymentPriceTotal);
            subOrder.add(map3);
            this.cache.put((Object)(CachePrefix.ORDER_PROMOTION.getPrefix() + order.getSn()), (Object)JsonUtil.objectToJson(itemList));
        }
        this.logger.info("\u6bcf\u9879\u76ee\u503c" + JsonUtil.objectToJson(subOrder));
        Map<String, IntSummaryStatistics> subMap = subOrder.stream().collect(Collectors.groupingBy(map -> (String)map.get("mid"), Collectors.summarizingInt(map -> Integer.parseInt((String)map.get("totalAmount")))));
        List subOrderMap = subMap.keySet().stream().map(key -> {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("mid", key);
            this.logger.info("\u6c42\u548c" + ((IntSummaryStatistics)subMap.get(key)).getSum());
            hashMap.put("totalAmount", ((IntSummaryStatistics)subMap.get(key)).getSum());
            return hashMap;
        }).collect(Collectors.toList());
        Auth2Token auth2Token = (Auth2Token)this.cache.get((Object)(CachePrefix.CONNECT_LOGIN.getPrefix() + uuid));
        if (auth2Token == null) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u767b\u5f55\u5931\u6548\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        String openid = auth2Token.getOpneId();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("version", "20191031");
        treeMap.put("msgId", msgId);
        treeMap.put("msgType", "wx.unifiedOrder");
        treeMap.put("requestTimestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        treeMap.put("merOrderId", outTradeNo);
        treeMap.put("mid", mId);
        treeMap.put("tid", tId);
        treeMap.put("divisionFlag", "true");
        treeMap.put("subOrders", JSONUtil.toJsonStr(subOrderMap));
        treeMap.put("subOpenId", openid);
        treeMap.put("instMid", "MINIDEFAULT");
        treeMap.put("totalAmount", CurrencyUtil.mul((double)param.getPrice(), (double)100.0).intValue() + "");
        treeMap.put("signType", "SHA256");
        treeMap.put("subAppId", appId);
        treeMap.put("platformAmount", "0");
        String bankUrl = this.javashopConfig.getScheme() + this.domainSettings.getCallback() + "/payment/callback/" + param.getTradeType() + "/" + param.getPaymentPluginId() + "/" + param.getClientType();
        treeMap.put("notifyUrl", bankUrl);
        StringBuffer sb = new StringBuffer();
        for (String key2 : treeMap.keySet()) {
            if (treeMap.get(key2) == null || "".equals(treeMap.get(key2))) continue;
            if (sb.length() == 0) {
                sb.append(key2 + "=" + (String)treeMap.get(key2));
                continue;
            }
            sb.append("&" + key2 + "=" + (String)treeMap.get(key2));
        }
        String sign = "";
        try {
            sign = Sha256.getSHA256((String)(sb.toString() + secret));
            treeMap.put("sign", sign);
            this.logger.info("\u94f6\u8054\u8bf7\u6c42\u652f\u4ed8\u62a5\u6587" + JsonUtil.objectToJson(treeMap));
            String ret = HttpUtils.http((String)url, (String)"", (int)80, treeMap, (String)"UTF-8");
            this.logger.error("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de===" + ret);
            JSONObject retJson = JSONObject.fromObject((Object)ret);
            String errCode = retJson.getString("errCode");
            String retMac = retJson.getString("sign");
            retJson.remove("mac");
            boolean bool = PaymentManagerImpl.checkSign((JSONObject)retJson, (String)retMac, (String)secret);
            if (bool) {
                TreeMap<String, String> weixinparams = new TreeMap<String, String>();
                JSONObject resOrder = retJson.getJSONObject("miniPayRequest");
                weixinparams.put("appId", resOrder.getString("appId"));
                weixinparams.put("nonceStr", resOrder.getString("nonceStr"));
                weixinparams.put("timeStamp", resOrder.getString("timeStamp"));
                weixinparams.put("package", resOrder.getString("package"));
                weixinparams.put("signType", resOrder.getString("signType"));
                weixinparams.put("paySign", resOrder.getString("paySign"));
                Form form = new Form();
                List items = this.getItems(weixinparams);
                form.setFormItems(items);
                return form;
            }
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u8c03\u7528\u94f6\u8054\u652f\u4ed8\u7b7e\u540d\u5f02\u5e38");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(PaymentErrorCode.E506.code(), "\u5b58\u5728\u5546\u5bb6\u6682\u4e0d\u652f\u6301\u5fae\u4fe1\u652f\u4ed8\uff01");
        }
    }

    public Form miniGoodsPay(Long id, Long buyId, String uuid, String sellerId, String price) {
        PaymentMethodDO paymentMethod = this.paymentMethodManager.getByPluginId("unionAffairsPlugin");
        if (paymentMethod == null) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u672a\u627e\u5230\u76f8\u5e94\u7684\u652f\u4ed8\u65b9\u5f0f[unionAffairsPlugin]");
        }
        String pcConfig = paymentMethod.getPcConfig();
        ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)pcConfig, ClientConfig.class);
        List payConfigItemList = config.getConfigList();
        String msgId = "";
        String mId = "";
        String tId = "";
        String url = "";
        String secret = "";
        String appId = "";
        for (PayConfigItem payConfigItem : payConfigItemList) {
            if (UnionAffairsConfigItem.msg_id.value().equals(payConfigItem.getName())) {
                msgId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.m_id.value().equals(payConfigItem.getName())) {
                mId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.t_id.value().equals(payConfigItem.getName())) {
                tId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.url.value().equals(payConfigItem.getName())) {
                url = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.secret.value().equals(payConfigItem.getName())) {
                secret = payConfigItem.getValue();
            }
            if (!UnionAffairsConfigItem.app_id.value().equals(payConfigItem.getName())) continue;
            appId = payConfigItem.getValue();
        }
        JSONArray subOrder = new JSONArray();
        JSONObject object = new JSONObject();
        ShopVO shopVO = this.shopClient.getShop(Long.valueOf(Long.parseLong(sellerId)));
        object.put((Object)"mid", (Object)shopVO.getmId());
        Double needPrice = Double.valueOf(price) * 100.0;
        object.put((Object)"totalAmount", (Object)needPrice);
        subOrder.add((Object)object);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(msgId);
        stringBuffer.append(DateUtil.format());
        int rand = (int)((Math.random() * 9.0 + 1.0) * 1000000.0);
        stringBuffer.append(rand);
        String outTradeNo = stringBuffer.toString();
        Auth2Token auth2Token = (Auth2Token)this.cache.get((Object)(CachePrefix.CONNECT_LOGIN.getPrefix() + uuid));
        PresaleBuyGoodsDO presaleBuyGoodsDO = (PresaleBuyGoodsDO)this.daoSupport.queryForObject(PresaleBuyGoodsDO.class, buyId);
        presaleBuyGoodsDO.setOutOrderNo(outTradeNo);
        this.daoSupport.update((Object)presaleBuyGoodsDO, buyId);
        this.logger.error("\u8ba2\u5355\u652f\u4ed8\u53d1\u9001\u8ba2\u5355\u53f7==========" + outTradeNo);
        String openid = auth2Token.getOpneId();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("version", "20191031");
        treeMap.put("msgId", msgId);
        treeMap.put("msgType", "wx.unifiedOrder");
        treeMap.put("requestTimestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        treeMap.put("merOrderId", outTradeNo);
        treeMap.put("mid", mId);
        treeMap.put("tid", tId);
        treeMap.put("divisionFlag", "true");
        treeMap.put("subOrders", subOrder.toString());
        treeMap.put("subOpenId", openid);
        treeMap.put("instMid", "MINIDEFAULT");
        treeMap.put("totalAmount", CurrencyUtil.mul((double)Double.valueOf(price), (double)100.0).intValue() + "");
        treeMap.put("signType", "SHA256");
        treeMap.put("subAppId", appId);
        treeMap.put("platformAmount", "0");
        String bankUrl = this.javashopConfig.getScheme() + this.domainSettings.getCallback() + "/payment/callback/pre-sale/pay-first-money/" + id + "/" + buyId + "/" + price + "";
        treeMap.put("notifyUrl", bankUrl);
        StringBuffer sb = new StringBuffer();
        for (String key : treeMap.keySet()) {
            if (treeMap.get(key) == null || "".equals(treeMap.get(key))) continue;
            if (sb.length() == 0) {
                sb.append(key + "=" + (String)treeMap.get(key));
                continue;
            }
            sb.append("&" + key + "=" + (String)treeMap.get(key));
        }
        String sign = "";
        try {
            sign = Sha256.getSHA256((String)(sb.toString() + secret));
        }
        catch (Exception key) {
            // empty catch block
        }
        treeMap.put("sign", sign);
        try {
            String ret = HttpUtils.http((String)url, (String)"", (int)80, treeMap, (String)"UTF-8");
            this.logger.error("\u94f6\u8054\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f========" + ret);
            JSONObject retJson = JSONObject.fromObject((Object)ret);
            String retMac = retJson.getString("sign");
            retJson.remove("mac");
            boolean bool = PaymentManagerImpl.checkSign((JSONObject)retJson, (String)retMac, (String)secret);
            if (bool) {
                TreeMap<String, String> weixinparams = new TreeMap<String, String>();
                JSONObject resOrder = retJson.getJSONObject("miniPayRequest");
                weixinparams.put("appId", resOrder.getString("appId"));
                weixinparams.put("nonceStr", resOrder.getString("nonceStr"));
                weixinparams.put("timeStamp", resOrder.getString("timeStamp"));
                weixinparams.put("package", resOrder.getString("package"));
                weixinparams.put("signType", resOrder.getString("signType"));
                weixinparams.put("paySign", resOrder.getString("paySign"));
                Form form = new Form();
                List items = this.getItems(weixinparams);
                form.setFormItems(items);
                return form;
            }
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u8c03\u7528\u94f6\u8054\u652f\u4ed8\u7b7e\u540d\u5f02\u5e38");
        }
        catch (Exception e) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u8c03\u7528\u94f6\u8054\u652f\u4ed8\u7b7e\u540d\u5f02\u5e38");
        }
    }

    public PayChannelMethodDetailAttr getChannle(Long storeId, String paymentId) {
        String sql = "select * from es_payment_channle where store_id=? and payment_id=?";
        PaymentChannleDO paymentChannleDO = (PaymentChannleDO)this.daoSupport.queryForObject(sql, PaymentChannleDO.class, new Object[]{storeId, paymentId});
        OperAttrStruct operAttrStruct = new OperAttrStruct();
        operAttrStruct.setOperOrgId(Integer.valueOf(1));
        operAttrStruct.setOperPost("1");
        operAttrStruct.setOperTime(DateUtil.getNowDay());
        operAttrStruct.setStaffId(Integer.valueOf(1));
        operAttrStruct.setStaffName("\u6d4b\u8bd5");
        ChannelMethodRelVO channelMethodRelVO = new ChannelMethodRelVO();
        channelMethodRelVO.setOperAttrStruct(operAttrStruct);
        channelMethodRelVO.setPayChannelId(paymentChannleDO.getChannleId());
        channelMethodRelVO.setStatusCd("1");
        channelMethodRelVO.setSignType("MD5");
        TreeMap<String, String> parameMap = new TreeMap<String, String>();
        parameMap.put("payChannelId", paymentChannleDO.getChannleId());
        parameMap.put("signType", "MD5");
        parameMap.put("statusCd", "1");
        String signStr = StringUtil.createSign(parameMap, (String)this.ztPaySetting.getKey());
        channelMethodRelVO.setSign(signStr);
        String resultPay = this.payTemplateInterfaceClient.getOrderChanlPay(channelMethodRelVO);
        System.out.println("\u4e2d\u53f0\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f" + resultPay);
        JSONObject jsonObjectPay = JSONObject.fromObject((Object)resultPay);
        JSONArray jsonArrayPay = jsonObjectPay.getJSONArray("payChannelMethodDetailAttr");
        List payChannelMethodDetailAttrs = JsonUtil.jsonToList((String)jsonArrayPay.toString(), PayChannelMethodDetailAttr.class);
        for (PayChannelMethodDetailAttr payChannelMethodDetailAttr : payChannelMethodDetailAttrs) {
            if (!payChannelMethodDetailAttr.getPayMethodId().equals(paymentId)) continue;
            return payChannelMethodDetailAttr;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkStatus(String sn, TradeTypeEnum tradeType, Integer times) {
        try {
            if (times >= 3) {
                return false;
            }
            String status = null;
            if (tradeType.equals((Object)TradeTypeEnum.ORDER)) {
                OrderDO orderDetailVO = this.orderManager.getModel(sn);
                if (orderDetailVO == null) throw new ServiceException(TradeErrorCode.E459.code(), "\u6b64\u8ba2\u5355\u4e0d\u5b58\u5728");
                status = orderDetailVO.getOrderStatus();
            } else {
                TradeDO tradeDO = this.tradeQueryManager.getModel(sn);
                if (tradeDO == null) throw new ServiceException(TradeErrorCode.E458.code(), "\u6b64\u4ea4\u6613\u4e0d\u5b58\u5728");
                status = tradeDO.getTradeStatus();
            }
            if (status.equals(OrderStatusEnum.CONFIRM.value())) return true;
            Thread.sleep(1000L);
            times = times + 1;
            return this.checkStatus(sn, tradeType, times);
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u8ba2\u5355\u662f\u5426\u53ef\u88ab\u652f\u4ed8,\u8ba2\u5355\u4e0d\u53ef\u88ab\u652f\u4ed8\uff0c\u91cd\u8bd5\u68c0\u6d4b" + times + ",\u6b21\uff0c\u6d88\u606f" + e.getMessage());
            times = times + 1;
            this.checkStatus(sn, tradeType, times);
            return false;
        }
    }

    private PaymentPluginManager findPlugin(String pluginId) {
        for (PaymentPluginManager plugin : this.paymentPluginList) {
            if (!plugin.getPluginId().equals(pluginId)) continue;
            return plugin;
        }
        return null;
    }

    private List<FormItem> getItems(Map<String, String> weixinparams) {
        ArrayList<FormItem> items = new ArrayList<FormItem>();
        for (String key : weixinparams.keySet()) {
            FormItem item = new FormItem();
            item.setItemName(key);
            item.setItemValue(weixinparams.get(key));
            items.add(item);
        }
        return items;
    }

    public String getAccessToken() {
        String token = (String)this.cache.get((Object)CachePrefix.UNION_TOKEN.getPrefix());
        if (StringUtil.isEmpty((String)token)) {
            String appId = "f0ec96ad2c3848b5b810e7aadf369e2f";
            String appKey = "775481e2556e4564985f5439a5e6a277";
            String timestamp = DateUtil.toString((Date)new Date(), (String)"yyyyMMddHHmmss");
            String nonce = PaymentManagerImpl.getnonce();
            String signMethod = "SHA256";
            String signature = Sha256.getSHA256((String)(appId + timestamp + nonce + appKey));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"appId", (Object)appId);
            jsonObject.put((Object)"timestamp", (Object)timestamp);
            jsonObject.put((Object)"nonce", (Object)nonce);
            jsonObject.put((Object)"signMethod", (Object)signMethod);
            jsonObject.put((Object)"signature", (Object)signature);
            String url = "";
            String body = HttpUtils.postResponse((String)url, (JSONObject)jsonObject);
            JSONObject json = JSONObject.fromObject((Object)body);
            token = json.getString("accessToken");
            this.cache.put((Object)CachePrefix.UNION_TOKEN.getPrefix(), (Object)token);
        }
        return token;
    }

    public String payPreSaleGoodsFirstMoney(Long id, Long buyId, Double firstMoney) {
        HttpServletRequest request = ThreadContextHolder.getHttpRequest();
        String queryId = request.getParameter("queryId");
        PresaleBuyGoodsDO presaleBuyGoodsDO = (PresaleBuyGoodsDO)this.daoSupport.queryForObject(PresaleBuyGoodsDO.class, buyId);
        presaleBuyGoodsDO.setPayOrderNo(queryId);
        presaleBuyGoodsDO.setPaymentTime(Long.valueOf(DateUtil.getDateline()));
        this.daoSupport.update((Object)presaleBuyGoodsDO, buyId);
        return this.promotionActiveClient.payFirstMoney(id, buyId, firstMoney);
    }

    public void sendCheckPaymentSmsCode(Long memberId) {
        Member member = this.memberClient.getModel(memberId);
        if (member == null) {
            throw new ServiceException(MemberErrorCode.E123.code(), "\u5f53\u524d\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        this.smsClient.sendSmsMessage("\u6821\u9a8c\u652f\u4ed8", member.getMobile(), SceneType.CARD_PAYMENT);
    }

    public void validate(Long memberId, String code) {
        Member member = this.memberClient.getModel(memberId);
        if (member == null) {
            throw new ServiceException(MemberErrorCode.E123.code(), "\u5f53\u524d\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        boolean isPass = this.smsClient.valid(SceneType.CARD_PAYMENT.name(), member.getMobile(), code);
        if (!isPass) {
            throw new ServiceException(MemberErrorCode.E107.code(), "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
    }
}

