/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import com.enation.app.javashop.client.trade.OrderClient;
import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.database.Page;
import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.rocketmq.MessageSender;
import com.enation.app.javashop.framework.rocketmq.MqMessage;
import com.enation.app.javashop.framework.sncreator.SnCreator;
import com.enation.app.javashop.framework.util.BeanUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.message.PaymentBillStatusChangeMsg;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.payment.dos.PaymentBillDO;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.trade.order.dto.OrderDetailDTO;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.PaymentBillManager;
import com.enation.app.javashop.service.payment.PaymentPluginManager;
import com.taobao.txc.client.aop.annotation.Propagation;
import com.taobao.txc.client.aop.annotation.TxcTransaction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PaymentBillManagerImpl
implements PaymentBillManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SnCreator snCreator;
    @Autowired
    @Qualifier(value="tradeDaoSupport")
    private DaoSupport daoSupport;
    @Autowired
    private OrderClient orderClient;
    @Autowired
    private List<PaymentPluginManager> paymentPluginList;
    @Autowired
    private Debugger debugger;
    @Autowired
    private MessageSender messageSender;

    public Page list(int page, int pageSize) {
        String sql = "select * from es_payment_bill  ";
        Page webPage = this.daoSupport.queryForPage(sql, page, pageSize, PaymentBillDO.class, new Object[0]);
        return webPage;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public PayBill add(PaymentBillDO paymentBill) {
        OrderDetailDTO orderDetailDTO;
        PaymentBillDO bill;
        PaymentBillDO paymentBillDO = this.getBySubSnAndServiceType(paymentBill.getSubSn(), paymentBill.getServiceType());
        paymentBill.setBillSn(paymentBill.getBillSn());
        if (paymentBillDO == null) {
            this.daoSupport.insert((Object)paymentBill);
            paymentBillDO = new PaymentBillDO();
            paymentBill.setBillId(this.daoSupport.getLastId("es_payment_bill"));
            BeanUtil.copyProperties((Object)paymentBill, (Object)paymentBillDO);
        } else {
            this.edit(paymentBill, paymentBillDO.getBillSn());
        }
        PaymentBillStatusChangeMsg msg = new PaymentBillStatusChangeMsg(paymentBillDO, paymentBillDO.getTradePrice());
        msg.setStatus("FAIL");
        if (!StringUtil.isEmpty((String)paymentBillDO.getPaymentPluginId())) {
            this.messageSender.send(new MqMessage("PAYMENT_BILL_CHANGE", "PAYMENT_BILL_CHANGE_ROUTING", (Object)msg));
        }
        if (paymentBillDO.getServiceType().equals(TradeTypeEnum.ORDER.name()) && (bill = this.getBySubSnAndServiceType((orderDetailDTO = this.orderClient.getModel(paymentBillDO.getSubSn())).getTradeSn(), TradeTypeEnum.TRADE.name())) != null) {
            PaymentBillStatusChangeMsg paymentBillStatusChangeMsg = new PaymentBillStatusChangeMsg(paymentBillDO, paymentBillDO.getTradePrice());
            msg.setStatus("FAIL");
            if (!StringUtil.isEmpty((String)bill.getPaymentPluginId())) {
                this.messageSender.send(new MqMessage("PAYMENT_BILL_CHANGE", "PAYMENT_BILL_CHANGE_ROUTING", (Object)paymentBillStatusChangeMsg));
            }
        }
        PayBill payBill = new PayBill(paymentBill);
        return payBill;
    }

    private PaymentBillDO getByBillSn(String billSn) {
        String sql = "select * from es_payment_bill where bill_sn = ?";
        return (PaymentBillDO)this.daoSupport.queryForObject(sql, PaymentBillDO.class, new Object[]{billSn});
    }

    public PaymentBillDO getBillByReturnTradeNo(String returnTradeNo) {
        String sql = "select * from es_payment_bill where return_trade_no = ? ";
        return (PaymentBillDO)this.daoSupport.queryForObject(sql, PaymentBillDO.class, new Object[]{returnTradeNo});
    }

    public PaymentBillDO getModel(String billSn) {
        String sql = "select * from es_payment_bill where bill_sn = ? ";
        return (PaymentBillDO)this.daoSupport.queryForObject(sql, PaymentBillDO.class, new Object[]{billSn});
    }

    public void edit(PaymentBillDO paymentBillDO, String sn) {
        HashMap<String, String> whereParam = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)sn)) {
            whereParam.put("bill_sn", paymentBillDO.getBillSn());
        } else {
            whereParam.put("bill_sn", sn);
        }
        this.daoSupport.update("es_payment_bill", (Object)paymentBillDO, whereParam);
    }

    public PaymentBillDO getBySubSnAndServiceType(String subSn, String serviceType) {
        String sql = "select * from es_payment_bill where sub_sn = ? and service_type = ?  ";
        return (PaymentBillDO)this.daoSupport.queryForObject(sql, PaymentBillDO.class, new Object[]{subSn, serviceType});
    }

    public boolean check(String billSn) {
        PaymentBillDO paymentBillDO = this.getModel(billSn);
        return paymentBillDO.getIsPay() == 0;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public void paySuccess(String billSn, String returnTradeNo, Double payPrice) {
        PaymentBillDO bill = this.getByBillSn(billSn);
        if (bill == null) {
            this.debugger.log("\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u3010" + bill.getServiceType() + "\u7c7b\u578b\u7684\u4ea4\u6613,\u7f16\u53f7\u4e3a\uff1a" + billSn + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u8d26\u5355\u3011");
            this.logger.error("\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u3010" + bill.getServiceType() + "\u7c7b\u578b\u7684\u4ea4\u6613,\u7f16\u53f7\u4e3a\uff1a" + billSn + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u8d26\u5355\u3011");
            throw new RuntimeException("\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a\u3010" + bill.getServiceType() + "\u7c7b\u578b\u7684\u4ea4\u6613\u7f16\u53f7\u4e3a\uff1a" + billSn + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u8d26\u5355\u3011");
        }
        this.logger.debug("\u627e\u5230\u8d26\u5355\uff1a");
        this.debugger.log("\u627e\u5230\u8d26\u5355\uff1a");
        this.logger.debug(bill.toString());
        this.debugger.log(bill.toString());
        if (!bill.getTradePrice().equals(payPrice)) {
            this.logger.error("\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8d26\u5355\u652f\u4ed8\u91d1\u989d\uff1a" + bill.getTradePrice() + "\uff0c\u56de\u8c03\u91d1\u989d\uff1a" + payPrice);
            this.debugger.log("\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8d26\u5355\u652f\u4ed8\u91d1\u989d\uff1a" + bill.getTradePrice() + "\uff0c\u56de\u8c03\u91d1\u989d\uff1a" + payPrice);
            throw new ServiceException(PaymentErrorCode.E508.code(), "\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        this.daoSupport.execute("update es_payment_bill set is_pay=1,return_trade_no=? where bill_id=?", new Object[]{returnTradeNo, bill.getBillId()});
        bill.setReturnTradeNo(returnTradeNo);
        PaymentBillStatusChangeMsg msg = new PaymentBillStatusChangeMsg(bill, payPrice);
        msg.setStatus("SUCCESS");
        this.messageSender.send(new MqMessage("PAYMENT_BILL_CHANGE", "PAYMENT_BILL_CHANGE_ROUTING", (Object)msg));
        this.logger.debug("\u66f4\u6539\u652f\u4ed8\u8d26\u5355\u72b6\u6001\u6210\u529f");
        this.debugger.log("\u66f4\u6539\u652f\u4ed8\u8d26\u5355\u72b6\u6001\u6210\u529f");
    }

    public void closeTrade(PaymentBillDO paymentBillDO) {
        PaymentPluginManager plugin = this.findPaymentPlugin(paymentBillDO.getPaymentPluginId());
        Map map = (Map)JsonUtil.jsonToObject((String)paymentBillDO.getPayConfig(), Map.class);
        List list = (List)map.get("config_list");
        HashMap<String, String> result = new HashMap<String, String>(list.size());
        if (list != null) {
            for (Map item : list) {
                result.put(item.get("name").toString(), item.get("value").toString());
            }
        }
        plugin.closeTrade(result, paymentBillDO.getBillSn());
    }

    private PaymentPluginManager findPaymentPlugin(String pluginId) {
        for (PaymentPluginManager plugin : this.paymentPluginList) {
            if (!plugin.getPluginId().equals(pluginId)) continue;
            return plugin;
        }
        return null;
    }
}

