/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.database.Page;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.SqlUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.trade.order.dos.PayLog;
import com.enation.app.javashop.model.trade.order.dto.PayLogQueryParam;
import com.enation.app.javashop.service.payment.PayLogManager;
import com.taobao.txc.client.aop.annotation.Propagation;
import com.taobao.txc.client.aop.annotation.TxcTransaction;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PayLogManagerImpl
implements PayLogManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="tradeDaoSupport")
    private DaoSupport daoSupport;

    public Page list(PayLogQueryParam queryParam) {
        StringBuffer sql = new StringBuffer("select * from es_pay_log ");
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!StringUtil.isEmpty((String)queryParam.getPaymentType())) {
            sqlList.add(" pay_way = ? ");
            paramList.add(queryParam.getPaymentType());
        }
        if (!StringUtil.isEmpty((String)queryParam.getPayStatus())) {
            sqlList.add(" pay_status = ? ");
            paramList.add(queryParam.getPayStatus());
        }
        if (queryParam.getStartTime() != null && queryParam.getEndTime() != null) {
            sqlList.add(" pay_time BETWEEN ? and ? ");
            paramList.add(queryParam.getStartTime());
            paramList.add(queryParam.getEndTime());
        }
        if (!StringUtil.isEmpty((String)queryParam.getMemberName())) {
            sqlList.add(" pay_member_name = ?");
            paramList.add(queryParam.getMemberName());
        }
        if (!StringUtil.isEmpty((String)queryParam.getOrderSn())) {
            sqlList.add(" order_sn like ?");
            paramList.add("%" + queryParam.getOrderSn() + "%");
        }
        if (!StringUtil.isEmpty((String)queryParam.getPayWay())) {
            sqlList.add(" pay_type like ?");
            String payWay = queryParam.getPayWay();
            String value = "";
            if ("alipay".equals(payWay)) {
                value = "%\u652f\u4ed8\u5b9d%";
            } else if ("wechat".equals(payWay)) {
                value = "%\u5fae\u4fe1%";
            }
            paramList.add(value);
        }
        if (queryParam.getStoreId() != null && !queryParam.getStoreId().equals(0)) {
            sqlList.add(" store_id = ?");
            paramList.add(queryParam.getStoreId());
        }
        sql.append(SqlUtil.sqlSplicing(sqlList));
        sql.append(" order by pay_log_id desc");
        Page webPage = this.daoSupport.queryForPage(sql.toString(), queryParam.getPageNo().intValue(), queryParam.getPageSize().intValue(), PayLog.class, paramList.toArray());
        return webPage;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public PayLog add(PayLog payLog) {
        this.daoSupport.insert((Object)payLog);
        return payLog;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public PayLog edit(PayLog payLog, Long id) {
        this.daoSupport.update((Object)payLog, id);
        return payLog;
    }

    @TxcTransaction(propagation=Propagation.REQUIRED)
    public void delete(Long id) {
        this.daoSupport.delete(PayLog.class, id);
    }

    public PayLog getModel(Long id) {
        return (PayLog)this.daoSupport.queryForObject(PayLog.class, id);
    }

    public PayLog getModel(String orderSn) {
        String sql = "select * from es_pay_log where order_sn=?";
        PayLog payLog = (PayLog)this.daoSupport.queryForObject(sql, PayLog.class, new Object[]{orderSn});
        return payLog;
    }

    public List<PayLog> exportExcel(PayLogQueryParam queryParam) {
        StringBuffer sql = new StringBuffer("select * from es_pay_log ");
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (queryParam.getStartTime() != null && queryParam.getEndTime() != null) {
            sqlList.add(" pay_time BETWEEN ? and ? ");
            paramList.add(queryParam.getStartTime());
            paramList.add(queryParam.getEndTime());
        }
        if (!StringUtil.isEmpty((String)queryParam.getMemberName())) {
            sqlList.add(" pay_member_name = ?");
            paramList.add(queryParam.getMemberName());
        }
        if (!StringUtil.isEmpty((String)queryParam.getOrderSn())) {
            sqlList.add(" order_sn like ?");
            paramList.add("%" + queryParam.getOrderSn() + "%");
        }
        if (!StringUtil.isEmpty((String)queryParam.getPayWay())) {
            sqlList.add(" pay_way = ?");
            paramList.add(queryParam.getPayWay());
        }
        if (queryParam.getStoreId() != null && !queryParam.getStoreId().equals(0)) {
            sqlList.add(" store_id = ?");
            paramList.add(queryParam.getStoreId());
        }
        sql.append(SqlUtil.sqlSplicing(sqlList));
        sql.append(" order by pay_log_id desc");
        List payLogList = this.daoSupport.queryForList(sql.toString(), PayLog.class, paramList.toArray());
        return payLogList;
    }
}

