/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment.impl;

import com.enation.app.javashop.client.member.ShopClient;
import com.enation.app.javashop.client.member.StoreClient;
import com.enation.app.javashop.client.trade.AfterSaleClient;
import com.enation.app.javashop.framework.database.DaoSupport;
import com.enation.app.javashop.framework.exception.ServiceException;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.rocketmq.MessageSender;
import com.enation.app.javashop.framework.rocketmq.MqMessage;
import com.enation.app.javashop.framework.rocketmq.RocketMQPubTopic;
import com.enation.app.javashop.framework.sncreator.SnCreator;
import com.enation.app.javashop.framework.util.CurrencyUtil;
import com.enation.app.javashop.framework.util.DateUtil;
import com.enation.app.javashop.framework.util.HttpUtils;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.Sha256;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.aftersale.dos.AfterSaleGoodsDO;
import com.enation.app.javashop.model.aftersale.dos.RefundDO;
import com.enation.app.javashop.model.aftersale.enums.RefundStatusEnum;
import com.enation.app.javashop.model.base.ZTPaySetting;
import com.enation.app.javashop.model.base.message.OrderRefundMsg;
import com.enation.app.javashop.model.errorcode.PaymentErrorCode;
import com.enation.app.javashop.model.payment.dos.PaymentBillDO;
import com.enation.app.javashop.model.payment.dos.PaymentChannleDO;
import com.enation.app.javashop.model.payment.dos.PaymentMethodDO;
import com.enation.app.javashop.model.payment.enums.UnionAffairsConfigItem;
import com.enation.app.javashop.model.payment.vo.ClientConfig;
import com.enation.app.javashop.model.payment.vo.OperAttrStruct;
import com.enation.app.javashop.model.payment.vo.PayAssemblyAttr;
import com.enation.app.javashop.model.payment.vo.PayConfigItem;
import com.enation.app.javashop.model.payment.vo.PayDetailAttr;
import com.enation.app.javashop.model.payment.vo.PayUserAttr;
import com.enation.app.javashop.model.payment.vo.RefunInfoVO;
import com.enation.app.javashop.model.payment.vo.RefundAssemblyAttr;
import com.enation.app.javashop.model.payment.vo.RefundBill;
import com.enation.app.javashop.model.promotion.presale.PresaleBuyGoodsDO;
import com.enation.app.javashop.model.shop.dos.Store;
import com.enation.app.javashop.model.shop.vo.ShopVO;
import com.enation.app.javashop.model.trade.order.dos.OrderDO;
import com.enation.app.javashop.model.trade.order.dos.OrderItemsDO;
import com.enation.app.javashop.model.trade.order.dos.OrderMetaDO;
import com.enation.app.javashop.service.payment.OrderRefundManager;
import com.enation.app.javashop.service.payment.PaymentBillManager;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class OrderRefundManagerImpl
implements OrderRefundManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SnCreator snCreator;
    @Autowired
    @Qualifier(value="tradeDaoSupport")
    private DaoSupport daoSupport;
    @Autowired
    private PaymentBillManager paymentBillManager;
    @Autowired
    private PaymentMethodManager paymentMethodManager;
    @Autowired
    private ShopClient shopClient;
    @Autowired
    private StoreClient storeClient;
    @Autowired
    private ZTPaySetting ztPaySetting;
    @Autowired
    private MessageSender messageSender;
    @Autowired
    private AfterSaleClient afterSaleClient;

    public Boolean refundOrder(RefundBill bill) {
        String sql = "select * from es_refund where sn=?";
        RefundDO refundDO = (RefundDO)this.daoSupport.queryForObject(sql, RefundDO.class, new Object[]{bill.getRefundSn()});
        this.logger.error("\u9000\u6b3e\u5355\u8ba2\u5355\u7f16\u53f7=================" + refundDO.getOrderSn());
        String orderSql = "select * from es_order where sn=?";
        OrderDO orderDO = (OrderDO)this.daoSupport.queryForObject(orderSql, OrderDO.class, new Object[]{refundDO.getOrderSn()});
        PaymentBillDO payBill = this.paymentBillManager.getBillByReturnTradeNo(bill.getReturnTradeNo());
        if (payBill == null) {
            throw new ServiceException(PaymentErrorCode.E504.code(), "\u652f\u4ed8\u8d26\u5355\u4e0d\u5b58\u5728");
        }
        PaymentMethodDO paymentMethod = this.paymentMethodManager.getByPluginId(payBill.getPaymentPluginId());
        if (paymentMethod == null) {
            throw new ServiceException(PaymentErrorCode.E501.code(), "\u672a\u627e\u5230\u76f8\u5e94\u7684\u652f\u4ed8\u65b9\u5f0f[" + payBill.getPaymentPluginId() + "]");
        }
        PaymentBillDO paymentBillDO = this.paymentBillManager.getBillByReturnTradeNo(bill.getReturnTradeNo());
        String pcConfig = paymentMethod.getPcConfig();
        ClientConfig config = (ClientConfig)JsonUtil.jsonToObject((String)pcConfig, ClientConfig.class);
        List payConfigItemList = config.getConfigList();
        String msgId = "";
        String mId = "";
        String tId = "";
        String url = "";
        String secret = "";
        String appId = "";
        for (PayConfigItem payConfigItem : payConfigItemList) {
            if (UnionAffairsConfigItem.msg_id.value().equals(payConfigItem.getName())) {
                msgId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.m_id.value().equals(payConfigItem.getName())) {
                mId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.t_id.value().equals(payConfigItem.getName())) {
                tId = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.url.value().equals(payConfigItem.getName())) {
                url = payConfigItem.getValue();
            }
            if (UnionAffairsConfigItem.secret.value().equals(payConfigItem.getName())) {
                secret = payConfigItem.getValue();
            }
            if (!UnionAffairsConfigItem.app_id.value().equals(payConfigItem.getName())) continue;
            appId = payConfigItem.getValue();
        }
        Double needPrice = bill.getRefundPrice();
        ShopVO shopVO = this.shopClient.getShop(orderDO.getSellerId());
        String presaleSql = "SELECT * FROM es_presale_buy_goods  where pay_balance = 2 and  order_sn = ?   ";
        PresaleBuyGoodsDO presaleBuyGoodsDO = (PresaleBuyGoodsDO)this.daoSupport.queryForObject(presaleSql, PresaleBuyGoodsDO.class, new Object[]{refundDO.getOrderSn()});
        if (presaleBuyGoodsDO != null && presaleBuyGoodsDO.getPayBalance() == 2) {
            needPrice = CurrencyUtil.sub((double)needPrice, (double)presaleBuyGoodsDO.getFirstPrice());
            StringBuffer fstringBuffer = new StringBuffer();
            fstringBuffer.append(msgId);
            fstringBuffer.append(DateUtil.format());
            int frand = (int)((Math.random() * 9.0 + 1.0) * 1000000.0);
            fstringBuffer.append(frand);
            String refundId = fstringBuffer.toString();
            this.refundFirst(refundId, mId, shopVO.getmId(), presaleBuyGoodsDO.getFirstPrice(), presaleBuyGoodsDO.getOutOrderNo(), tId, secret, url, presaleBuyGoodsDO.getPaymentTime());
        }
        if (BigDecimal.valueOf(needPrice).compareTo(BigDecimal.ZERO) <= 0) {
            return this.refundByZero(bill, refundDO, orderDO);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(msgId);
        stringBuffer.append(DateUtil.format());
        int rand = (int)((Math.random() * 9.0 + 1.0) * 1000000.0);
        stringBuffer.append(rand);
        String refundOrderId = stringBuffer.toString();
        needPrice = CurrencyUtil.mul((double)needPrice, (double)100.0);
        JSONArray subOrder = new JSONArray();
        JSONObject object = new JSONObject();
        object.put((Object)"mid", (Object)shopVO.getmId());
        object.put((Object)"totalAmount", (Object)needPrice);
        subOrder.add((Object)object);
        Map map = bill.getConfigMap();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("version", "20191031");
        treeMap.put("msgType", "refund");
        treeMap.put("refundOrderId", refundOrderId);
        treeMap.put("instMid", "MINIDEFAULT");
        treeMap.put("requestTimestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        treeMap.put("merOrderId", paymentBillDO.getBillSn());
        treeMap.put("mid", mId);
        treeMap.put("tid", tId);
        treeMap.put("billDate", DateUtil.toString((Long)orderDO.getPaymentTime(), (String)"yyyy-MM-dd"));
        treeMap.put("refundAmount", String.valueOf(needPrice.intValue()));
        treeMap.put("platformAmount", "0");
        treeMap.put("subOrders", subOrder.toString());
        treeMap.put("signType", "SHA256");
        treeMap.put("subAppId", appId);
        StringBuffer sb = new StringBuffer();
        for (String key : treeMap.keySet()) {
            if (treeMap.get(key) == null || "".equals(treeMap.get(key))) continue;
            if (sb.length() == 0) {
                sb.append(key + "=" + (String)treeMap.get(key));
                continue;
            }
            sb.append("&" + key + "=" + (String)treeMap.get(key));
        }
        String sign = "";
        try {
            sign = Sha256.getSHA256((String)(sb.toString() + secret));
        }
        catch (Exception key) {
            // empty catch block
        }
        treeMap.put("sign", sign);
        try {
            String ret = HttpUtils.http((String)url, (String)"", (int)80, treeMap, (String)"UTF-8");
            JSONObject retJson = JSONObject.fromObject((Object)ret);
            this.logger.error("\u94f6\u8054\u9000\u6b3e\u8fd4\u56de\u63a5\u53e3==" + retJson);
            String errCode = retJson.getString("errCode");
            if ("SUCCESS".equals(errCode)) {
                return this.refundByZero(bill, refundDO, orderDO);
            }
            this.afterSaleClient.addLog(bill.getRefundSn(), "\u94f6\u8054\u9000\u6b3e\u5931\u8d25\u539f\u56e0\u4e3a:" + retJson.getString("errMsg"), "\u7cfb\u7edf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String queryRefundStatus(RefundBill bill) {
        return RefundStatusEnum.COMPLETED.value();
    }

    public boolean refundByZero(RefundBill bill, RefundDO refundDO, OrderDO orderDO) {
        String goodsSql = "select * from es_as_goods where service_sn=?";
        List afterSaleGoodsDOList = this.daoSupport.queryForList(goodsSql, AfterSaleGoodsDO.class, new Object[]{refundDO.getSn()});
        ArrayList<RefundAssemblyAttr> refundAssemblyAttrList = new ArrayList<RefundAssemblyAttr>();
        String metaSql = "select * from es_order_meta where order_sn=?";
        List orderMetaDOList = this.daoSupport.queryForList(metaSql, OrderMetaDO.class, new Object[]{orderDO.getSn()});
        String payArrt = "";
        String paySerialId = "";
        String payChannle = "";
        for (OrderMetaDO orderMetaDO : orderMetaDOList) {
            if ("payAssemblyAttr".equals(orderMetaDO.getMetaKey())) {
                payArrt = orderMetaDO.getMetaValue();
            }
            if ("paySerialId".equals(orderMetaDO.getMetaKey())) {
                paySerialId = orderMetaDO.getMetaValue();
            }
            if (!"PAY".equals(orderMetaDO.getMetaKey())) continue;
            payChannle = orderMetaDO.getMetaValue();
        }
        List payAssemblyAttrList = JsonUtil.jsonToList((String)payArrt, PayAssemblyAttr.class);
        List payDetailAttrList = JsonUtil.jsonToList((String)payChannle, PayDetailAttr.class);
        for (AfterSaleGoodsDO afterSaleGoodsDO : afterSaleGoodsDOList) {
            PaymentChannleDO paymentChannleDO;
            String paySql;
            String itemSql = "select * from es_order_items where goods_id=? and product_id=? and order_sn=?";
            OrderItemsDO orderItemsDO = (OrderItemsDO)this.daoSupport.queryForObject(itemSql, OrderItemsDO.class, new Object[]{afterSaleGoodsDO.getGoodsId(), afterSaleGoodsDO.getSkuId(), orderDO.getSn()});
            double num = CurrencyUtil.div((double)afterSaleGoodsDO.getReturnNum().intValue(), (double)afterSaleGoodsDO.getShipNum().intValue(), (int)4);
            if (orderItemsDO.getCardPrice() > 0.0) {
                paySql = "select * from es_payment_channle where store_id=? and plugin_id='cardPlugin'";
                paymentChannleDO = (PaymentChannleDO)this.daoSupport.queryForObject(paySql, PaymentChannleDO.class, new Object[]{orderDO.getStoreId()});
                Double cardPrice = CurrencyUtil.mul((double)orderItemsDO.getCardPrice(), (double)num);
                Double[] cardTotalPrice = new Double[]{CurrencyUtil.mul((double)cardPrice, (double)100.0)};
                this.logger.info("\u50a8\u503c\u5361\u9000\u6b3e\u91d1\u989d:" + cardTotalPrice[0]);
                payAssemblyAttrList.stream().filter(payAssemblyAttr -> String.valueOf(payAssemblyAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId()) && payAssemblyAttr.getPayChannelSerial().contains(orderDO.getSn()) && payAssemblyAttr.getPayChannelSerial().split("-")[1].equals(orderItemsDO.getItemCode())).forEach(payAssemblyAttr -> {
                    RefundAssemblyAttr refundAssemblyAttr = new RefundAssemblyAttr();
                    refundAssemblyAttr.setPayMethodId(payAssemblyAttr.getPayMethodId());
                    if (CurrencyUtil.sub((double)payAssemblyAttr.getSendAmount().intValue(), (double)cardTotalPrice[0]) >= 0.0) {
                        this.logger.info("\u5c01\u88c5\u50a8\u503c\u5361\u91d1\u989d" + cardTotalPrice[0].intValue());
                        refundAssemblyAttr.setTotalAmount(payAssemblyAttr.getRealAmount());
                        refundAssemblyAttr.setRefundFee(Integer.valueOf(cardTotalPrice[0].intValue()));
                    } else {
                        this.logger.info("\u5c01\u88c5\u50a8\u503c\u5361\u91d1\u989d" + payAssemblyAttr.getSendAmount());
                        refundAssemblyAttr.setTotalAmount(payAssemblyAttr.getRealAmount());
                        refundAssemblyAttr.setRefundFee(payAssemblyAttr.getSendAmount());
                        cardTotalPrice[0] = CurrencyUtil.sub((double)cardTotalPrice[0], (double)payAssemblyAttr.getSendAmount().intValue());
                    }
                    refundAssemblyAttr.setRefundChannelSerial(this.snCreator.create(3));
                    refundAssemblyAttr.setOperAssemblyPaySerialId(payAssemblyAttr.getAssemblyPaySerialId());
                    refundAssemblyAttr.setOperSerialId(payAssemblyAttr.getPayChannelSerial());
                    payDetailAttrList.stream().filter(payDetailAttr -> String.valueOf(payDetailAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId())).forEach(payDetailAttr -> {
                        refundAssemblyAttr.setPayTicketNumber(payDetailAttr.getTicketNumber());
                        refundAssemblyAttr.setTicketNumber(payDetailAttr.getTicketNumber());
                        if (StringUtil.notEmpty((String)payDetailAttr.getVipNumber())) {
                            refundAssemblyAttr.setVipNumber(payDetailAttr.getVipNumber());
                        }
                    });
                    refundAssemblyAttrList.add(refundAssemblyAttr);
                });
            }
            if (orderItemsDO.getCouponPrice() > 0.0) {
                paySql = "select * from es_payment_channle where store_id=? and plugin_id='couponPlugin'";
                paymentChannleDO = (PaymentChannleDO)this.daoSupport.queryForObject(paySql, PaymentChannleDO.class, new Object[]{orderDO.getStoreId()});
                Double couponPrice = CurrencyUtil.mul((double)orderItemsDO.getCouponPrice(), (double)num);
                Double couponTotalPrice = CurrencyUtil.mul((double)couponPrice, (double)100.0);
                RefundAssemblyAttr refundAssemblyAttr = new RefundAssemblyAttr();
                refundAssemblyAttr.setPayMethodId(Integer.valueOf(paymentChannleDO.getPaymentId()));
                refundAssemblyAttr.setTotalAmount(Integer.valueOf(couponTotalPrice.intValue()));
                refundAssemblyAttr.setRefundFee(Integer.valueOf(couponTotalPrice.intValue()));
                refundAssemblyAttr.setRefundChannelSerial(this.snCreator.create(3));
                refundAssemblyAttr.setTicketChannelId(paymentChannleDO.getChannleId());
                payAssemblyAttrList.stream().filter(payAssemblyAttr -> String.valueOf(payAssemblyAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId())).findAny().ifPresent(payAssemblyAttr -> {
                    refundAssemblyAttr.setOperAssemblyPaySerialId(payAssemblyAttr.getAssemblyPaySerialId());
                    refundAssemblyAttr.setOperSerialId(payAssemblyAttr.getPayChannelSerial());
                });
                payDetailAttrList.stream().filter(payDetailAttr -> String.valueOf(payDetailAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId())).forEach(payDetailAttr -> {
                    refundAssemblyAttr.setPayTicketNumber(payDetailAttr.getTicketNumber());
                    refundAssemblyAttr.setTicketNumber(payDetailAttr.getTicketNumber());
                    refundAssemblyAttr.setTicketType(payDetailAttr.getTicketType());
                    if (StringUtil.notEmpty((String)payDetailAttr.getVipNumber())) {
                        refundAssemblyAttr.setVipNumber(payDetailAttr.getVipNumber());
                    }
                });
                refundAssemblyAttrList.add(refundAssemblyAttr);
            }
            if (!(orderItemsDO.getRefundPrice() > 0.0)) continue;
            paySql = "select * from es_payment_channle where store_id=? and plugin_id='unionAffairsPlugin'";
            paymentChannleDO = (PaymentChannleDO)this.daoSupport.queryForObject(paySql, PaymentChannleDO.class, new Object[]{orderDO.getStoreId()});
            Double unionPrice = CurrencyUtil.mul((double)orderItemsDO.getRefundPrice(), (double)num);
            String presaleSql = "SELECT * FROM es_presale_buy_goods  where pay_balance = 2 and  order_sn = ?   ";
            PresaleBuyGoodsDO presaleBuyGoodsDO = (PresaleBuyGoodsDO)this.daoSupport.queryForObject(presaleSql, PresaleBuyGoodsDO.class, new Object[]{orderDO.getSn()});
            if (presaleBuyGoodsDO != null) {
                unionPrice = CurrencyUtil.sub((double)unionPrice, (double)presaleBuyGoodsDO.getFirstPrice());
                payAssemblyAttrList.stream().filter(payAssemblyAttr -> String.valueOf(payAssemblyAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId()) && payAssemblyAttr.getPayChannelSerial().contains("DJ" + orderItemsDO.getOrderSn())).forEach(payAssemblyAttr -> {
                    RefundAssemblyAttr refundAssemblyAttr = new RefundAssemblyAttr();
                    refundAssemblyAttr.setPayMethodId(payAssemblyAttr.getPayMethodId());
                    refundAssemblyAttr.setTotalAmount(payAssemblyAttr.getRealAmount());
                    refundAssemblyAttr.setRefundFee(Integer.valueOf(CurrencyUtil.mul((double)presaleBuyGoodsDO.getFirstPrice(), (double)100.0).intValue()));
                    refundAssemblyAttr.setRefundChannelSerial(this.snCreator.create(3));
                    refundAssemblyAttr.setOperAssemblyPaySerialId(payAssemblyAttr.getAssemblyPaySerialId());
                    refundAssemblyAttr.setOperSerialId(payAssemblyAttr.getPayChannelSerial());
                    payDetailAttrList.stream().filter(payDetailAttr -> String.valueOf(payDetailAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId())).forEach(payDetailAttr -> {
                        refundAssemblyAttr.setPayTicketNumber(payDetailAttr.getTicketNumber());
                        refundAssemblyAttr.setTicketNumber(payDetailAttr.getTicketNumber());
                        if (StringUtil.notEmpty((String)payDetailAttr.getVipNumber())) {
                            refundAssemblyAttr.setVipNumber(payDetailAttr.getVipNumber());
                        }
                    });
                    refundAssemblyAttrList.add(refundAssemblyAttr);
                });
            }
            Double unionTotalPrice = CurrencyUtil.mul((double)unionPrice, (double)100.0);
            payAssemblyAttrList.stream().filter(payAssemblyAttr -> String.valueOf(payAssemblyAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId()) && payAssemblyAttr.getPayChannelSerial().contains("W" + orderItemsDO.getOrderSn())).forEach(payAssemblyAttr -> {
                RefundAssemblyAttr refundAssemblyAttr = new RefundAssemblyAttr();
                refundAssemblyAttr.setPayMethodId(payAssemblyAttr.getPayMethodId());
                refundAssemblyAttr.setTotalAmount(payAssemblyAttr.getRealAmount());
                refundAssemblyAttr.setRefundFee(Integer.valueOf(unionTotalPrice.intValue()));
                refundAssemblyAttr.setRefundChannelSerial(this.snCreator.create(3));
                refundAssemblyAttr.setOperAssemblyPaySerialId(payAssemblyAttr.getAssemblyPaySerialId());
                refundAssemblyAttr.setOperSerialId(payAssemblyAttr.getPayChannelSerial());
                payDetailAttrList.stream().filter(payDetailAttr -> String.valueOf(payDetailAttr.getPayMethodId()).equals(paymentChannleDO.getPaymentId())).forEach(payDetailAttr -> {
                    refundAssemblyAttr.setPayTicketNumber(payDetailAttr.getTicketNumber());
                    refundAssemblyAttr.setTicketNumber(payDetailAttr.getTicketNumber());
                    if (StringUtil.notEmpty((String)payDetailAttr.getVipNumber())) {
                        refundAssemblyAttr.setVipNumber(payDetailAttr.getVipNumber());
                    }
                });
                refundAssemblyAttrList.add(refundAssemblyAttr);
            });
        }
        RefunInfoVO refunInfoVO = new RefunInfoVO();
        OperAttrStruct operAttrStruct = new OperAttrStruct();
        operAttrStruct.setOperOrgId(Integer.valueOf(1));
        operAttrStruct.setOperPost("1");
        operAttrStruct.setOperTime(DateUtil.getNowDay());
        operAttrStruct.setStaffId(Integer.valueOf(1));
        operAttrStruct.setStaffName("\u5fae\u5546\u57ce\u7ba1\u7406\u4eba\u5458");
        Long storeId = orderDO.getStoreId();
        Store store = this.storeClient.getStore(storeId);
        PayUserAttr payUserAttr = new PayUserAttr();
        payUserAttr.setAppId(this.ztPaySetting.getAppId());
        payUserAttr.setStoreName(store.getStoreName());
        payUserAttr.setStoreCode(store.getStoreCode());
        payUserAttr.setCashierDeskCode("999999");
        payUserAttr.setPayUserSerial(refundDO.getSn());
        payUserAttr.setStoreId(store.getStoreId().toString());
        String orderNo = orderDO.getSn();
        refunInfoVO.setNotifyUrl("");
        refunInfoVO.setOperAttrStruct(operAttrStruct);
        refunInfoVO.setOrderNumber(orderNo);
        refunInfoVO.setPayUserAttr(payUserAttr);
        refunInfoVO.setRefundAssemblyAttr(refundAssemblyAttrList);
        refunInfoVO.setSignType("MD5");
        refunInfoVO.setPaySerialId(paySerialId);
        refunInfoVO.setTradeType(Integer.valueOf(1));
        refunInfoVO.setOriginCardRefundFlag("1");
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("signType", "MD5");
        parameters.put("paySerialId", refunInfoVO.getPaySerialId());
        parameters.put("orderNumber", refunInfoVO.getOrderNumber());
        parameters.put("tradeType", "1");
        String ztSign = StringUtil.createSign(parameters, (String)this.ztPaySetting.getKey());
        refunInfoVO.setSign(ztSign);
        OrderRefundMsg orderRefundMsg = new OrderRefundMsg();
        orderRefundMsg.setRefunInfoVO(refunInfoVO);
        orderRefundMsg.setRefundSn(bill.getRefundSn());
        this.messageSender.send(new MqMessage("ORDER_REFUND_TO_ZT", "ORDER_REFUND_TO_ZT_ROUTING", (Object)orderRefundMsg, RocketMQPubTopic.ORDER.name()));
        return true;
    }

    public void refundFirst(String refundId, String mId, String submId, Double refundPrice, String outOrderNo, String tId, String secret, String url, Long time) {
        JSONArray subOrder = new JSONArray();
        JSONObject object = new JSONObject();
        refundPrice = refundPrice * 100.0;
        object.put((Object)"mid", (Object)submId);
        object.put((Object)"totalAmount", (Object)refundPrice);
        subOrder.add((Object)object);
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("version", "20191031");
        treeMap.put("msgType", "refund");
        treeMap.put("refundOrderId", refundId);
        treeMap.put("instMid", "MINIDEFAULT");
        treeMap.put("requestTimestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        treeMap.put("merOrderId", outOrderNo);
        treeMap.put("mid", mId);
        treeMap.put("tid", tId);
        treeMap.put("billDate", DateUtil.toString((Long)time, (String)"yyyy-MM-dd"));
        treeMap.put("refundAmount", String.valueOf(refundPrice.intValue()));
        treeMap.put("platformAmount", "0");
        treeMap.put("subOrders", subOrder.toString());
        treeMap.put("signType", "SHA256");
        StringBuffer sb = new StringBuffer();
        for (String key : treeMap.keySet()) {
            if (treeMap.get(key) == null || "".equals(treeMap.get(key))) continue;
            if (sb.length() == 0) {
                sb.append(key + "=" + (String)treeMap.get(key));
                continue;
            }
            sb.append("&" + key + "=" + (String)treeMap.get(key));
        }
        String sign = "";
        try {
            sign = Sha256.getSHA256((String)(sb.toString() + secret));
        }
        catch (Exception key) {
            // empty catch block
        }
        treeMap.put("sign", sign);
        try {
            String ret = HttpUtils.http((String)url, (String)"", (int)80, treeMap, (String)"UTF-8");
            JSONObject retJson = JSONObject.fromObject((Object)ret);
            this.logger.error("\u94f6\u8054\u9000\u6b3e\u8fd4\u56de\u63a5\u53e3==" + retJson);
            String string = retJson.getString("errCode");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

