/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.service.payment;

import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.model.base.DomainHelper;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.vo.PayBill;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.PaymentBillManager;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPaymentPlugin {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int isTest = 0;
    public static final String SUCCESS = "SUCCESS";
    public static final String FAIL = "FAIL";
    public static final String REFUND_ERROR_MESSAGE = "{REFUND_ERROR_MESSAGE}";
    @Autowired
    private PaymentMethodManager paymentMethodManager;
    @Autowired
    private PaymentBillManager paymentBillManager;
    @Autowired
    private DomainHelper domainHelper;

    protected Map<String, String> getConfig(ClientType clientType) {
        return this.paymentMethodManager.getConfig(clientType.getDbColumn(), this.getPluginId());
    }

    protected abstract String getPluginId();

    protected String getReturnUrl(PayBill bill) {
        String tradeType = bill.getTradeType().name();
        String payMode = bill.getPayMode();
        return this.domainHelper.getCallback() + "/payment/return/" + tradeType + "/" + payMode + "/" + this.getPluginId();
    }

    protected String getCallBackUrl(TradeTypeEnum tradeType, ClientType clientType) {
        return this.domainHelper.getCallback() + "/payment/callback/" + tradeType + "/" + this.getPluginId() + "/" + clientType;
    }

    protected void paySuccess(String billSn, String returnTradeNo, double payPrice) {
        this.paymentBillManager.paySuccess(billSn, returnTradeNo, Double.valueOf(payPrice));
    }
}

