/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.api.manager.payment;

import com.enation.app.javashop.client.promotion.PayTemplateInterfaceClient;
import com.enation.app.javashop.framework.util.DateUtil;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.ZTPaySetting;
import com.enation.app.javashop.model.payment.dos.PaymentChannleDO;
import com.enation.app.javashop.model.payment.vo.ChannelMethodRelVO;
import com.enation.app.javashop.model.payment.vo.ChannelRelVO;
import com.enation.app.javashop.model.payment.vo.OperAttrStruct;
import com.enation.app.javashop.model.payment.vo.PayChannelAttr;
import com.enation.app.javashop.model.payment.vo.PayChannelMethodDetailAttr;
import com.enation.app.javashop.model.payment.vo.PaymentChannleVO;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/payment/pay"})
@Api(description="\u652f\u4ed8\u65b9\u5f0f\u6e20\u9053\u76f8\u5173API")
public class StorePaymentController {
    @Autowired
    private PayTemplateInterfaceClient payTemplateInterfaceClient;
    @Autowired
    private PaymentMethodManager paymentMethodManager;
    @Autowired
    private ZTPaySetting ztPaySetting;

    @ApiOperation(value="\u83b7\u53d6\u95e8\u5e97\u7684\u652f\u4ed8\u6e20\u9053")
    @PostMapping(value={"channel-list/{store_id}"})
    public List<PayChannelAttr> channelList(@PathVariable(value="store_id") Long storeId) {
        OperAttrStruct operAttrStruct = new OperAttrStruct();
        operAttrStruct.setOperOrgId(Integer.valueOf(1));
        operAttrStruct.setOperPost("1");
        operAttrStruct.setOperTime(DateUtil.getNowDay());
        operAttrStruct.setStaffId(Integer.valueOf(1));
        operAttrStruct.setStaffName("\u6d4b\u8bd5");
        ChannelRelVO channelRelVO = new ChannelRelVO();
        channelRelVO.setOperAttrStruct(operAttrStruct);
        channelRelVO.setAppId(this.ztPaySetting.getAppId());
        channelRelVO.setPracticalShopId(storeId.toString());
        channelRelVO.setSignType("MD5");
        channelRelVO.setStatusCd("1");
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appId", this.ztPaySetting.getAppId());
        parameters.put("practicalShopId", storeId);
        parameters.put("signType", "MD5");
        parameters.put("statusCd", "1");
        String sign = StringUtil.createSign(parameters, (String)this.ztPaySetting.getKey());
        channelRelVO.setSign(sign);
        String result = this.payTemplateInterfaceClient.getOrderChanl(channelRelVO);
        System.out.println("\u4e2d\u53f0\u83b7\u53d6\u6e20\u9053" + result);
        JSONObject jsonObject = JSONObject.fromObject((Object)result);
        JSONArray jsonArray = jsonObject.getJSONArray("payChannelAttr");
        List payChannelAttrList = JsonUtil.jsonToList((String)jsonArray.toString(), PayChannelAttr.class);
        return payChannelAttrList;
    }

    @ApiOperation(value="\u83b7\u53d6\u652f\u4ed8\u6e20\u9053\u7684\u652f\u4ed8\u65b9\u5f0f")
    @PostMapping(value={"payment-list/{channel_id}"})
    public List<PayChannelMethodDetailAttr> paymentlList(@PathVariable(value="channel_id") String channelId) {
        OperAttrStruct operAttrStruct = new OperAttrStruct();
        operAttrStruct.setOperOrgId(Integer.valueOf(1));
        operAttrStruct.setOperPost("1");
        operAttrStruct.setOperTime(DateUtil.getNowDay());
        operAttrStruct.setStaffId(Integer.valueOf(1));
        operAttrStruct.setStaffName("\u5fae\u5546\u57ce");
        ChannelMethodRelVO channelMethodRelVO = new ChannelMethodRelVO();
        channelMethodRelVO.setOperAttrStruct(operAttrStruct);
        channelMethodRelVO.setPayChannelId(channelId);
        channelMethodRelVO.setStatusCd("1");
        channelMethodRelVO.setSignType("MD5");
        TreeMap<String, String> parameMap = new TreeMap<String, String>();
        parameMap.put("payChannelId", channelId);
        parameMap.put("signType", "MD5");
        parameMap.put("statusCd", "1");
        String signStr = StringUtil.createSign(parameMap, (String)this.ztPaySetting.getKey());
        channelMethodRelVO.setSign(signStr);
        String resultPay = this.payTemplateInterfaceClient.getOrderChanlPay(channelMethodRelVO);
        System.out.println("\u4e2d\u53f0\u83b7\u53d6\u652f\u4ed8\u65b9\u5f0f" + resultPay);
        JSONObject jsonObjectPay = JSONObject.fromObject((Object)resultPay);
        JSONArray jsonArrayPay = jsonObjectPay.getJSONArray("payChannelMethodDetailAttr");
        List payChannelMethodDetailAttrs = JsonUtil.jsonToList((String)jsonArrayPay.toString(), PayChannelMethodDetailAttr.class);
        return payChannelMethodDetailAttrs;
    }

    @ApiOperation(value="\u4fdd\u5b58\u95e8\u5e97\u652f\u4ed8\u6e20\u9053")
    @PostMapping(value={"payment-save"})
    public List<PaymentChannleDO> paymentSave(@RequestBody List<PaymentChannleVO> paymentChannleVOList) {
        return this.paymentMethodManager.paymentSave(paymentChannleVOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u95e8\u5e97\u76f8\u5173\u4fe1\u606f")
    @PostMapping(value={"get-info/{store_id}/{plugin_id}"})
    public PaymentChannleDO getInfo(@PathVariable(value="store_id") Long storeId, @PathVariable(value="plugin_id") String pluginId) {
        return this.paymentMethodManager.getInfo(storeId, pluginId);
    }
}

