/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.api.manager.payment;

import com.enation.app.javashop.client.system.SettingClient;
import com.enation.app.javashop.framework.util.JsonUtil;
import com.enation.app.javashop.framework.util.StringUtil;
import com.enation.app.javashop.model.base.PaymentSetting;
import com.enation.app.javashop.model.base.SettingGroup;
import com.enation.app.javashop.model.payment.vo.PaymentSettingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/payment/settings"})
@Api(description="\u652f\u4ed8\u8bbe\u7f6eAPI")
public class PaymentSettingManagerController {
    @Autowired
    private SettingClient settingClient;

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u652f\u4ed8\u8bbe\u7f6e\u4fe1\u606f")
    public PaymentSettingVO getGoodsSetting() {
        String json = this.settingClient.get(SettingGroup.PAYMENT);
        if (StringUtil.isEmpty((String)json)) {
            PaymentSettingVO paySetting = new PaymentSettingVO(PaymentSetting.CARD_CLOSE.name());
            this.settingClient.save(SettingGroup.PAYMENT, (Object)paySetting);
            return paySetting;
        }
        return (PaymentSettingVO)JsonUtil.jsonToObject((String)json, PaymentSettingVO.class);
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58\u652f\u4ed8\u5ba1\u6838\u8bbe\u7f6e\u4fe1\u606f")
    public PaymentSettingVO save(@Valid PaymentSettingVO paySetting) {
        this.settingClient.save(SettingGroup.PAYMENT, (Object)paySetting);
        return paySetting;
    }
}

