/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.api.manager.payment;

import com.enation.app.javashop.framework.database.Page;
import com.enation.app.javashop.model.payment.dos.PaymentMethodDO;
import com.enation.app.javashop.model.payment.vo.PaymentPluginVO;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/admin/payment/payment-methods"})
@Api(description="\u652f\u4ed8\u65b9\u5f0f\u8868\u76f8\u5173API")
public class PaymentMethodManagerController {
    @Autowired
    private PaymentMethodManager paymentMethodManager;

    @ApiOperation(value="\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5217\u8868", response=PaymentMethodDO.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="page_no", value="\u9875\u7801", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="page_size", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=true, dataType="int", paramType="query")})
    @GetMapping
    public Page list(@ApiIgnore Integer pageNo, @ApiIgnore Integer pageSize) {
        return this.paymentMethodManager.list(pageNo.intValue(), pageSize.intValue());
    }

    @ApiOperation(value="\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f", response=PaymentMethodDO.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="payment_plugin_id", value="\u652f\u4ed8\u63d2\u4ef6id", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="payment_method", value="\u652f\u4ed8\u65b9\u5f0f\u5bf9\u8c61", required=true, dataType="PaymentPluginVO", paramType="body")})
    @PutMapping(value={"/{payment_plugin_id}"})
    public PaymentMethodDO add(@Valid @RequestBody @ApiIgnore PaymentPluginVO paymentMethod, @PathVariable(value="payment_plugin_id") String paymentPluginId) {
        return this.paymentMethodManager.add(paymentMethod, paymentPluginId);
    }

    @GetMapping(value={"/{plugin_id}"})
    @ApiOperation(value="\u67e5\u8be2\u4e00\u4e2a\u652f\u4ed8\u65b9\u5f0f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="plugin_id", value="\u8981\u67e5\u8be2\u7684\u652f\u4ed8\u63d2\u4ef6id", required=true, dataType="string", paramType="path")})
    public PaymentPluginVO get(@PathVariable(value="plugin_id") String pluginId) {
        return this.paymentMethodManager.getByPlugin(pluginId);
    }
}

