/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.api.manager.payment;

import com.enation.app.javashop.framework.context.user.AdminUserContext;
import com.enation.app.javashop.framework.database.Page;
import com.enation.app.javashop.model.trade.order.dos.PayLog;
import com.enation.app.javashop.model.trade.order.dto.PayLogQueryParam;
import com.enation.app.javashop.service.payment.PayLogManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(description="\u4ed8\u6b3e\u5355\u76f8\u5173API")
@RestController
@RequestMapping(value={"/admin/trade/orders"})
@Validated
public class PayLogManagerController {
    @Autowired
    private PayLogManager payLogManager;

    @ApiOperation(value="\u67e5\u8be2\u4ed8\u6b3e\u5355\u5217\u8868")
    @GetMapping(value={"/pay-log"})
    public Page<PayLog> list(PayLogQueryParam param) {
        if (AdminUserContext.getAdmin().getStore().equals(1)) {
            param.setStoreId(AdminUserContext.getAdmin().getStoreId());
        }
        Page page = this.payLogManager.list(param);
        return page;
    }

    @ApiOperation(value="\u6536\u6b3e\u5355\u5bfc\u51faExcel")
    @ApiImplicitParams(value={@ApiImplicitParam(name="order_sn", value="\u8ba2\u5355\u7f16\u53f7", dataType="String", paramType="query"), @ApiImplicitParam(name="pay_way", value="\u652f\u4ed8\u65b9\u5f0f", dataType="String", paramType="query"), @ApiImplicitParam(name="start_time", value="\u5f00\u59cb\u65f6\u95f4", dataType="Long", paramType="query"), @ApiImplicitParam(name="end_time", value="\u7ed3\u675f\u65f6\u95f4", dataType="Long", paramType="query"), @ApiImplicitParam(name="member_name", value="\u4f1a\u5458\u540d", dataType="String", paramType="query")})
    @GetMapping(value={"/pay-log/list"})
    public List<PayLog> excel(@ApiIgnore String orderSn, @ApiIgnore String payWay, @ApiIgnore String memberName, @ApiIgnore Long startTime, @ApiIgnore Long endTime) {
        PayLogQueryParam param = new PayLogQueryParam();
        param.setOrderSn(orderSn);
        param.setPayWay(payWay);
        param.setMemberName(memberName);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        if (AdminUserContext.getAdmin().getStore().equals(1)) {
            param.setStoreId(AdminUserContext.getAdmin().getStoreId());
        }
        return this.payLogManager.exportExcel(param);
    }
}

