/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.api.client;

import com.enation.app.javashop.model.payment.dos.PaymentMethodDO;
import com.enation.app.javashop.model.payment.dto.PayParam;
import com.enation.app.javashop.model.payment.vo.Form;
import com.enation.app.javashop.model.payment.vo.PayChannelMethodDetailAttr;
import com.enation.app.javashop.service.payment.PaymentManager;
import com.enation.app.javashop.service.payment.PaymentMethodManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/client/payment"})
@Validated
@ApiIgnore
public class PaymentClientController {
    @Autowired
    private PaymentManager paymentManager;
    @Autowired
    private PaymentMethodManager paymentMethodManager;

    @RequestMapping(value={"/pay"}, method={RequestMethod.POST})
    public Map pay(@RequestBody PayParam param) {
        return this.paymentManager.pay(param);
    }

    @RequestMapping(value={"/bill"}, method={RequestMethod.GET})
    public String queryBill(@RequestParam(value="sub_sn") String subSn, @RequestParam(value="service_type") String serviceType) {
        return this.paymentManager.queryResult(subSn, serviceType);
    }

    @RequestMapping(value={"/{plugin_id}"}, method={RequestMethod.GET})
    public PaymentMethodDO getByPluginId(@PathVariable(value="plugin_id") String pluginId) {
        return this.paymentMethodManager.getByPluginId(pluginId);
    }

    @RequestMapping(value={"/pay-pre-sale"}, method={RequestMethod.POST})
    public Form payPreSaleGoods(@RequestParam(value="id") Long id, @RequestParam(value="buy_id") Long buyId, @RequestParam(value="uuid") String uuid, @RequestParam(value="seller_id") String sellerId, @RequestParam(value="price") String price) {
        return this.paymentManager.miniGoodsPay(id, buyId, uuid, sellerId, price);
    }

    @RequestMapping(value={"/channle"}, method={RequestMethod.GET})
    public PayChannelMethodDetailAttr getChannle(@RequestParam(value="store_id") Long storeId, @RequestParam(value="payment_id") String paymentId) {
        return this.paymentManager.getChannle(storeId, paymentId);
    }
}

