/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.api.buyer.payment;

import com.enation.app.javashop.client.system.ValidatorClient;
import com.enation.app.javashop.framework.context.user.UserContext;
import com.enation.app.javashop.framework.logs.Debugger;
import com.enation.app.javashop.framework.logs.Logger;
import com.enation.app.javashop.framework.logs.LoggerFactory;
import com.enation.app.javashop.framework.util.AbstractRequestUtil;
import com.enation.app.javashop.model.base.DomainHelper;
import com.enation.app.javashop.model.payment.dto.PayParam;
import com.enation.app.javashop.model.payment.enums.ClientType;
import com.enation.app.javashop.model.payment.enums.PayMode;
import com.enation.app.javashop.model.payment.vo.Form;
import com.enation.app.javashop.model.payment.vo.PaymentMethodVO;
import com.enation.app.javashop.model.trade.order.enums.TradeTypeEnum;
import com.enation.app.javashop.service.payment.PaymentManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(description="\u4ea4\u6613\u652f\u4ed8API")
@RestController
@RequestMapping(value={"/payment"})
@Validated
public class PaymentController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Debugger debugger;
    @Autowired
    private PaymentManager paymentManager;
    @Autowired
    private DomainHelper domainHelper;
    @Autowired
    private ValidatorClient validatorClient;

    @ApiOperation(value="\u67e5\u8be2\u652f\u6301\u7684\u652f\u4ed8\u65b9\u5f0f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="client_type", value="\u8c03\u7528\u5ba2\u6237\u7aefPC,WAP,NATIVE,REACT", required=true, dataType="String", paramType="path", allowableValues="PC,WAP,NATIVE,REACT")})
    @GetMapping(value={"/{client_type}"})
    public List<PaymentMethodVO> queryPayments(@PathVariable(name="client_type") String clientType) {
        List list = this.paymentManager.queryPayments(clientType);
        return list;
    }

    @ApiIgnore
    @ApiOperation(value="\u63a5\u6536\u652f\u4ed8\u5f02\u6b65\u56de\u8c03")
    @RequestMapping(value={"/callback/{trade_type}/{plugin_id}/{client_type}"})
    public String payCallback(@PathVariable(name="trade_type") String tradeType, @PathVariable(name="plugin_id") String paymentPluginId, @PathVariable(name="client_type") String clientType) {
        this.logger.error("\u63a5\u6536\u5230\u56de\u8c03\u6d88\u606f");
        this.logger.error("tradeType:[" + tradeType + "],paymentPluginId:[" + paymentPluginId + "],clientType:[" + clientType + "]");
        String result = this.paymentManager.payCallback(paymentPluginId, ClientType.valueOf((String)clientType));
        return result;
    }

    @ApiIgnore
    @ApiOperation(value="\u63a5\u6536\u652f\u4ed8\u540c\u6b65\u56de\u8c03")
    @GetMapping(value={"/return/{trade_type}/{pay_mode}/{plugin_id}"}, produces={"text/html"})
    public String payReturn(@PathVariable(name="trade_type") String tradeType, @PathVariable(name="plugin_id") String paymentPluginId, @PathVariable(name="pay_mode") String payMode, HttpServletResponse response) {
        this.paymentManager.payReturn(TradeTypeEnum.valueOf((String)tradeType), paymentPluginId);
        String serverName = this.domainHelper.getBuyerDomain();
        if (AbstractRequestUtil.isMobile()) {
            serverName = this.domainHelper.getMobileDomain();
        }
        String url = serverName + "/payment-complete?type=" + tradeType;
        String jumpHtml = "<script>";
        jumpHtml = PayMode.qr.name().equals(payMode) ? jumpHtml + "window.parent.location.href='" + url + "'" : jumpHtml + "location.href='" + url + "'";
        jumpHtml = jumpHtml + "</script>";
        return jumpHtml;
    }

    @ApiOperation(value="\u4e3b\u52a8\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c")
    @GetMapping(value={"/order/pay/query/{trade_type}/{sn}"})
    public String query(@PathVariable(name="trade_type") String tradeType, @Valid PayParam param, @PathVariable(name="sn") String sn) {
        String result = this.paymentManager.queryResult(sn, tradeType);
        return result;
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u5bf9\u4e00\u4e2a\u4ea4\u6613\u53d1\u8d77\u652f\u4ed8(\u94f6\u8054\u652f\u4ed8)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u8981\u652f\u4ed8\u7684\u4ea4\u6613sn", required=true, dataType="String", paramType="path"), @ApiImplicitParam(name="trade_type", value="\u4ea4\u6613\u7c7b\u578b", required=true, dataType="String", paramType="path", allowableValues="trade,order"), @ApiImplicitParam(name="uuid", value="\u7528\u6237uuid", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/mini/union/{trade_type}/{sn}"})
    public Form miniUnionPayTrade(@PathVariable(name="sn") String sn, @PathVariable(name="trade_type") String tradeType, @Valid PayParam param, @ApiIgnore String uuid) {
        param.setSn(sn);
        param.setTradeType(tradeType);
        Form form = this.paymentManager.miniUnionPay(param, uuid);
        return form;
    }

    @ApiOperation(value="\u9884\u552e\u5b9a\u91d1\u652f\u4ed8(\u94f6\u8054\u652f\u4ed8)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1\u5217\u8868Id", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="buy_id", value="\u8d2d\u4e70Id", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="uuid", value="\u7528\u6237uuid", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="seller_id", value="\u5e97\u94faId", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="price", value="\u652f\u4ed8\u4ef7\u683c", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="pay_balance", value="\u652f\u4ed8\u72b6\u6001\uff080\u652f\u4ed8\u5b9a\u91d1\u30011\u652f\u4ed8\u5c3e\u6b3e\uff09", required=true, dataType="int", paramType="query")})
    @PostMapping(value={"/mini/pre-sale-goods"})
    public Form miniGoodsPayTrade(@ApiIgnore Long id, @ApiIgnore Long buyId, @ApiIgnore String uuid, @ApiIgnore String sellerId, @ApiIgnore String price) {
        Form form = this.paymentManager.miniGoodsPay(id, buyId, uuid, sellerId, price);
        return form;
    }

    @ApiIgnore
    @ApiOperation(value="\u9884\u552e\u652f\u4ed8\u5b9a\u91d1\u5f02\u6b65\u56de\u8c03")
    @RequestMapping(value={"/callback/pre-sale/pay-first-money/{id}/{buy_id}/{first_money}"})
    public String payPreSaleGoodsFirstMoney(@PathVariable(value="id") Long id, @PathVariable(value="buy_id") Long buyId, @PathVariable(value="first_money") Double firstMoney) {
        this.debugger.log("------------------------------");
        this.debugger.log("\u9884\u552e\u652f\u4ed8\u5b9a\u91d1\u5f02\u6b65\u56de\u8c03\u63a5\u6536\u5230\u56de\u8c03\u6d88\u606f");
        this.debugger.log("id:[" + id + "],buyId:[" + buyId + "],firstMoney:[" + firstMoney + "]");
        this.debugger.log("------------------------------");
        return this.paymentManager.payPreSaleGoodsFirstMoney(id, buyId, firstMoney);
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u9a8c\u8bc1\u652f\u4ed8\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sms-code/{mobile}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7", required=true, dataType="String", paramType="path")})
    public void smsCode(@PathVariable(value="mobile") String mobile) {
        this.validatorClient.validate();
        this.paymentManager.sendCheckPaymentSmsCode(UserContext.getBuyer().getUid());
    }

    @GetMapping(value={"/sms-code/validate"})
    @ApiOperation(value="\u9a8c\u8bc1\u624b\u673a\u8bc1\u9a8c\u8bc1\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sms_code", value="\u9a8c\u8bc1\u7801", required=true, dataType="String", paramType="query")})
    public void checkExchangeBindCode(@Valid @ApiIgnore @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") @Valid @NotEmpty(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") String smsCode) {
        this.paymentManager.validate(UserContext.getBuyer().getUid(), smsCode);
    }
}

