/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.util;

import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public final class ResultSetUtil {
    public static Object convertValue(Object value, Class<?> convertType) {
        if (null == value) {
            return ResultSetUtil.convertNullValue(convertType);
        }
        if (value.getClass() == convertType) {
            return value;
        }
        if (value instanceof Number) {
            return ResultSetUtil.convertNumberValue(value, convertType);
        }
        if (value instanceof Date) {
            return ResultSetUtil.convertDateValue(value, convertType);
        }
        if (String.class.equals(convertType)) {
            return value.toString();
        }
        return value;
    }

    private static Object convertNullValue(Class<?> convertType) {
        switch (convertType.getName()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    private static Object convertNumberValue(Object value, Class<?> convertType) {
        Number number = (Number)value;
        switch (convertType.getName()) {
            case "byte": {
                return number.byteValue();
            }
            case "short": {
                return number.shortValue();
            }
            case "int": {
                return number.intValue();
            }
            case "long": {
                return number.longValue();
            }
            case "double": {
                return number.doubleValue();
            }
            case "float": {
                return Float.valueOf(number.floatValue());
            }
            case "java.math.BigDecimal": {
                return new BigDecimal(number.toString());
            }
            case "java.lang.Object": {
                return value;
            }
            case "java.lang.String": {
                return value.toString();
            }
        }
        throw new ShardingJdbcException("Unsupported data type:%s", convertType);
    }

    private static Object convertDateValue(Object value, Class<?> convertType) {
        Date date = (Date)value;
        switch (convertType.getName()) {
            case "java.sql.Date": {
                return new java.sql.Date(date.getTime());
            }
            case "java.sql.Time": {
                return new Time(date.getTime());
            }
            case "java.sql.Timestamp": {
                return new Timestamp(date.getTime());
            }
        }
        throw new ShardingJdbcException("Unsupported Date type:%s", convertType);
    }

    public static int compareTo(Comparable thisValue, Comparable otherValue, OrderType orderType, OrderType nullOrderType) {
        if (null == thisValue && null == otherValue) {
            return 0;
        }
        if (null == thisValue) {
            return orderType == nullOrderType ? -1 : 1;
        }
        if (null == otherValue) {
            return orderType == nullOrderType ? 1 : -1;
        }
        return OrderType.ASC == orderType ? thisValue.compareTo(otherValue) : -thisValue.compareTo(otherValue);
    }

    private ResultSetUtil() {
    }
}

