/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.statement;

import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractPreparedStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.MasterSlaveConnection;
import com.dangdang.ddframe.rdb.sharding.parsing.SQLJudgeEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLStatement;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;

public final class MasterSlavePreparedStatement
extends AbstractPreparedStatementAdapter {
    private final MasterSlaveConnection connection;
    private final Collection<PreparedStatement> routedStatements = new LinkedList<PreparedStatement>();

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, 1);
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = connection;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : connection.getConnection(sqlStatement.getType())) {
            PreparedStatement preparedStatement = each.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.routedStatements.add(preparedStatement);
        }
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this.connection = connection;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : connection.getConnection(sqlStatement.getType())) {
            PreparedStatement preparedStatement = each.prepareStatement(sql, autoGeneratedKeys);
            this.routedStatements.add(preparedStatement);
        }
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, int[] columnIndexes) throws SQLException {
        this.connection = connection;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : connection.getConnection(sqlStatement.getType())) {
            PreparedStatement preparedStatement = each.prepareStatement(sql, columnIndexes);
            this.routedStatements.add(preparedStatement);
        }
    }

    public MasterSlavePreparedStatement(MasterSlaveConnection connection, String sql, String[] columnNames) throws SQLException {
        this.connection = connection;
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        for (Connection each : connection.getConnection(sqlStatement.getType())) {
            PreparedStatement preparedStatement = each.prepareStatement(sql, columnNames);
            this.routedStatements.add(preparedStatement);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().executeUpdate();
    }

    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        for (PreparedStatement each : this.routedStatements) {
            result = each.execute();
        }
        return result;
    }

    @Override
    public void clearBatch() throws SQLException {
        for (PreparedStatement each : this.routedStatements) {
            each.clearBatch();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        for (PreparedStatement each : this.routedStatements) {
            each.addBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().executeBatch();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().getResultSet();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Preconditions.checkState((1 == this.routedStatements.size() ? 1 : 0) != 0);
        return this.routedStatements.iterator().next().getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.routedStatements.iterator().next().getResultSetHoldability();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.routedStatements.iterator().next().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.routedStatements.iterator().next().getResultSetType();
    }

    @Override
    public MasterSlaveConnection getConnection() {
        return this.connection;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.routedStatements;
    }
}

