package com.bizvane.wechat.feign.model.req;

import com.bizvane.wechat.feign.model.req.base.WxBaseAppIdReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotBlank;

@EqualsAndHashCode(callSuper = true)
@Data
public class WxGetUnlimitedQRCodeReq extends WxBaseAppIdReq {

    @ApiModelProperty("scene 字段的值会作为 query 参数传递给小程序/小游戏用户扫描该码进入小程序/小游戏后，开发者可以获取到二维码中的 scene 值，再做处理逻辑。* 最大32个可见字符，只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~，其它字符请自行编码为合法字符")
    @NotBlank(message = "scene is not null")
    private String scene;
    @ApiModelProperty(value = "二维码的宽度，单位 px。最小 280px，最大 1280px;默认是430")
    private Integer width;
    @ApiModelProperty(value = "跳转页面，默认是主页，页面 page", notes = "默认是主页，页面 page，例如 pages/index/index，根路径前不要填加 /，不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面。scancode_time为系统保留参数，不允许配置")
    private String page;
    @ApiModelProperty(value = "checkPath  默认true 检查 page 是否存在，为 true 时 page 必须是已经发布的小程序存在的页面（否则报错）；")
    private Boolean checkPath = true;
    @ApiModelProperty(value = "默认\"release\" 要打开的小程序版本。正式版为 \"release\"，体验版为 \"trial\"，开发版为 \"develop\"")
    private String envVersion = "release";
    @ApiModelProperty(value = "默认true 自动配置线条颜色，如果颜色依然是黑色，则说明不建议配置主色调")
    private Boolean autoColor = true;
    @ApiModelProperty(value = "autoColor 为 false 时生效，使用 rgb 设置颜色 例如 {\"r\":\"xxx\",\"g\":\"xxx\",\"b\":\"xxx\"}")
    private WxMaCodeLineColor lineColor;
    @ApiModelProperty(value = "isHyaline  是否需要透明底色， is_hyaline 为true时，生成透明底色的小程序码")
    private Boolean isHyaline = false;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class WxMaCodeLineColor {
        private String r = "0", g = "0", b = "0";
    }
}
