package com.bizvane.wechat.feign.model.req;

import com.bizvane.wechat.feign.model.req.base.WxBaseAppIdReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
public class WxSendSubscribeMsgReq extends WxBaseAppIdReq {

    @ApiModelProperty("模板Id")
    @NotBlank(message = "模板Id is not null")
    private String templateId;

    /**
     * 点击模板卡片后的跳转页面，仅限本小程序内的页面.
     * <pre>
     * 参数：page
     * 是否必填： 否
     * 描述： 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转。
     * </pre>
     */
    @ApiModelProperty(value = "点击模板卡片后的跳转页面，仅限本小程序内的页面.")
    private String page;

    /**
     * 模板内容，不填则下发空模板.
     * <pre>
     * 参数：data
     * 是否必填： 是
     * 描述： 模板内容，不填则下发空模板
     * </pre>
     */
    @ApiModelProperty(value = "模板内容，不填则下发空模板.")
    private List<MsgData> data;

    /**
     * 接收者（用户）的 openid.
     * <pre>
     * 参数：touser
     * 是否必填： 是
     * 描述： 接收者（用户）的 openid
     * </pre>
     */
    @ApiModelProperty("接收者（用户）的 openid.")
    @NotBlank(message = "toUser is not null")
    private String toUser;


    @ApiModelProperty("跳转小程序类型：developer为开发版；trial为体验版；formal为正式版；默认为正式版")
    private String miniprogramState = "formal";


    @ApiModelProperty("进入小程序查看的语言类型，支持zh_CN(简体中文)、en_US(英文)、zh_HK(繁体中文)、zh_TW(繁体中文)，默认为zh_CN")
    private String lang = "zh_CN";


    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MsgData implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String value;
    }
}
