package com.bizvane.wechat.feign.feign;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechat.feign.model.req.WxAuthReq;
import com.bizvane.wechat.feign.model.req.WxGetUserInfoReq;
import com.bizvane.wechat.feign.model.rsp.WxGetPhoneNumberInfoRsp;
import com.bizvane.wechat.feign.model.rsp.WxGetUserInfoRsp;
import com.bizvane.wechat.feign.model.vo.WxAuthVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;


@FeignClient(value = "${feign.client.wechat.name}", path = "${feign.client.wechat.path}/wxAuth")
public interface WechatAuthRpcFeign {

    @PostMapping("/login")
    @ResponseBody
    ResponseData<WxAuthVo> login(@RequestBody @Validated WxAuthReq req);


    @PostMapping("/getUserInfo")
    @ResponseBody
    ResponseData<WxGetUserInfoRsp> getUserInfo(@RequestBody @Validated WxGetUserInfoReq req);


    @PostMapping("/getPhoneNumber")
    @ResponseBody
    ResponseData<WxGetPhoneNumberInfoRsp> getPhoneNumber(@RequestBody @Validated WxAuthReq req);

}
