package com.bizvane.wechatfacade.models.vo;

import com.bizvane.wechatfacade.constants.WxPublicConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

@Getter
@Setter
public class CreateQRCodeRequestVO implements Serializable {
    @ApiModelProperty(value = "企业id", name = "sysCompanyId", required = true)
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
    @NotNull
    private Long sysBrandId;

    @ApiModelProperty(value = "生成二维码方式 参数格式0:默认1:p 2:pn", name = "createQRCodeWay", required = true)
    private Byte createQRCodeWay = 2;

    @ApiModelProperty(value = "类型：1-公众号，2-小程序", name = "wxPublicType", required = true)
    private String wxPublicType = WxPublicConstants.WX_PUBLIC_TYPE_MINI;

    @ApiModelProperty(value = "小程序类型：10-个人中心小程序，20-微商城小程序", name = "miniProgramType", required = true)
    private String miniProgramType = WxPublicConstants.MINI_PROGRAM_TYPE_PERSION;

    @ApiModelProperty(value = "页面路径：必须是已经发布的小程序存在的页面（否则报错），例如 pages/index/index, 根路径前不要填加 /,不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面", name = "path", required = false, example = "pages/template01/coupon-scancode/main")
    @NotBlank
    private String path;

    @ApiModelProperty(value = "参数json格式", name = "param", required = true)
    private String param;

    @ApiModelProperty(value = "二维码的宽度，单位 px，最小 280px，最大 1280px", name = "width", required = true)
    private Double width;

    @ApiModelProperty(value = "文件后缀名称", name = "qrCodeSuffix", required = true)
    private String qrCodeSuffix = "img";

    @ApiModelProperty(value = "过期时间", name = "expiredDate", required = true)
    private Date expiredDate;

    @ApiModelProperty(value = "logo地址", name = "logoUrl", required = true)
    private String logoUrl;

    @ApiModelProperty(value = "是否返回域名", name = "isShowDomain", required = true)
    private Boolean isShowDomain = true;

    @ApiModelProperty(value = "来源类型", name = "qrCodeSourceType", required = true)
    @NotNull
    private Integer qrCodeSourceType;

    @ApiModelProperty(value = "使用 rgb 设置颜色", name = "lineColor", required = true)
    private Map<String,Number> lineColor;

    @ApiModelProperty(value = "是否需要透明底色", name = "isHyaline", required = true)
    private Boolean isHyaline= false;

}
