package com.bizvane.wechatfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class QRCodeCreateContainImgTemporaryRequestBO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @NotNull
  @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
  private Long sysBrandId;

  @ApiModelProperty(value = "业务类型：guide-导购，store-门店, channel-渠道, trace-追踪", name = "businessType", required = true, example = "guide")
  private String businessType;

  @NotBlank
  @ApiModelProperty(value = "业务编号，例如业务类型是导购时，就传导购的id或者编号或者traceid", name = "businessCode", required = true, example = "1001")
  private String businessCode;
  
  @ApiModelProperty(value = "二维码中心自定义图片url", name = "logoImageUrl", required = true, example = "http://www.image.com/logo")
  private String logoImageUrl;
}
