package com.bizvane.wechatfacade.enums;

import com.bizvane.wechatfacade.constants.WxPublicConstants;
import org.apache.commons.lang3.StringUtils;

public enum WxPublicMsgTypeEnum {
    WX_PUBLIC_MSG_EVENT_TYPE(0,"event","","事件"),
    WX_PUBLIC_MSG_SUBSCRIBE_TYPE(1,"subscribe", WxPublicConstants.WX_PUBLIC_SUBSCRIBE_TOPIC,"关注公众号"),
    WX_PUBLIC_MSG_ACCEPT_TEXT_TYPE(2,"text",WxPublicConstants.WX_PUBLIC_MSG_ACCEPT_TEXT_TOPIC,"接收文本消息");

    private int code;
    private String type;
    private String topic;
    private String msg;

    WxPublicMsgTypeEnum(int code,String type,String topic, String msg) {
        this.code = code;
        this.type = type;
        this.topic = topic;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static WxPublicMsgTypeEnum getWxPublicMsgSubscribeType(String type){
        WxPublicMsgTypeEnum wxPublicMsgTypeEnum = null;
        if(StringUtils.isNotBlank(type)){
            for (WxPublicMsgTypeEnum wx:WxPublicMsgTypeEnum.values()) {
              if(type.equals(wx.getType())){
                  wxPublicMsgTypeEnum = wx;
              }
            }
        }
        return wxPublicMsgTypeEnum;
    }

}
