package com.bizvane.wechatfacade.enums;

import org.apache.commons.lang3.StringUtils;

public enum WxPublicMsgTypeEnum {
    WX_PUBLIC_MSG_EVENT_TYPE(0,"event","","事件"),
    WX_PUBLIC_MSG_SUBSCRIBE_TYPE(1,"subscribe","_subscribe","关注公众号"),
    WX_PUBLIC_MSG_TXT_TYPE(2,"text","_text","接收文本消息");

    private int code;
    private String type;
    private String topicSuffix;
    private String msg;

    WxPublicMsgTypeEnum(int code,String type,String topicSuffix, String msg) {
        this.code = code;
        this.type = type;
        this.topicSuffix = topicSuffix;
        this.msg = msg;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTopicSuffix() {
        return topicSuffix;
    }

    public void setTopicSuffix(String topicSuffix) {
        this.topicSuffix = topicSuffix;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static WxPublicMsgTypeEnum getWxPublicMsgSubscribeType(String type){
        WxPublicMsgTypeEnum wxPublicMsgTypeEnum = null;
        if(StringUtils.isNotBlank(type)){
            for (WxPublicMsgTypeEnum wx:WxPublicMsgTypeEnum.values()) {
              if(type.equals(wx.getType())){
                  wxPublicMsgTypeEnum = wx;
              }
            }
        }
        return wxPublicMsgTypeEnum;
    }

}
