package com.bizvane.wechatfacade.interfaces;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bizvane.utils.responseinfo.ResponseData;

/**
 * Created by yunjie.tian on 2018/7/9.
 */
@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/wxAuthorize")
public interface PublicAuthorizedCallbackFeign {

    @RequestMapping("/getPreAutoCode")
    @ResponseBody
    ResponseData<String> getPreAutoCode(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId, @RequestParam("miniProgramType") String miniProgramType);
    
    @RequestMapping("/getComponentAccessToken")
    @ResponseBody
    ResponseData<String> getComponentAccessToken();

}
