package com.bizvane.wechatfacade.models.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel("创建带参数二维码")
public class QRCodeCreateRequestVO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @NotNull
  @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
  private Long sysBrandId;
  
  @NotEmpty
  @ApiModelProperty(value = "业务类型：guide-导购，store-门店", name = "businessType", required = true, example = "guide")
  private String businessType;
  
  @NotEmpty
  @ApiModelProperty(value = "业务编号，业务类型是导购时传导购id和门店id，用逗号隔开，业务类型是门店时传门店id", name = "businessCode", required = true, example = "1001")
  private String businessCode;

  @NotEmpty
  @ApiModelProperty(value = "企业编号", name = "companyCode", required = true, example = "")
  private String companyCode;

  @NotEmpty
  @ApiModelProperty(value = "品牌编号", name = "brandCode", required = true, example = "")
  private String brandCode;

  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public Long getSysBrandId() {
    return sysBrandId;
  }

  public void setSysBrandId(Long sysBrandId) {
    this.sysBrandId = sysBrandId;
  }

  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }

  public String getBusinessCode() {
    return businessCode;
  }

  public void setBusinessCode(String businessCode) {
    this.businessCode = businessCode;
  }
  
}
