package com.bizvane.wechatfacade.interfaces;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.vo.WechatSubscribeMessageVO;
import com.bizvane.wechatfacade.models.vo.WxSendMessageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @ClassName WxSendMessageFeign
 * @DescriptTion :
 * @Auther: wd
 * @Date :2019/1/17 15:02
 */
@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/WxSendMessage")
@Api(value="公众号发送消息接口")
public interface WxSendMessageFeign {
    /**
     * 发送消息
     * @param wxSendMessageVO
     * @return
     */
    @PostMapping("sendInfoMessage")
    @ApiOperation("发送消息")
    ResponseData sendInfoMessage(@RequestBody WxSendMessageVO wxSendMessageVO);

    /**
     * 发送小程序订阅消息
     * @param wxSendMessageVO
     * @return
     */
    @PostMapping("sendWechatSubscribeInfoMessage")
    @ApiOperation("发送小程序订阅消息")
    ResponseData sendWechatSubscribeInfoMessage(@RequestBody WechatSubscribeMessageVO wxSendMessageVO);

    /**
     * 发送消息-统一服务消息接口
     * @param wxSendMessageVO
     * @return
     */
    @PostMapping("sendUniformInfoMessage")
    @ApiOperation("发送消息")
    ResponseData sendUniformInfoMessage(@RequestBody WxSendMessageVO wxSendMessageVO);
}
