package com.bizvane.wechatfacade.interfaces;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetPhoneNumberResponseVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoRequestVO;
import com.bizvane.wechatfacade.models.vo.UserAuthorizationGetUserInfoResponseVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/userAuthorization")
@Api(value = "小程序授权相关接口",tags = {"小程序授权相关接口"})
public interface UserAuthorizationFeign {
  
  @ApiOperation(value = "授权code获取session_key")
  @RequestMapping(value = "/byCode", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<String> byCode(@RequestParam("code") String code, @RequestParam("appid") String appid);
  
  @ApiOperation(value = "获取会员卡信息")
  @RequestMapping(value = "/getUserInfo", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<UserAuthorizationGetUserInfoResponseVO> getUserInfo(@RequestBody UserAuthorizationGetUserInfoRequestVO vo);
  
  @ApiOperation(value = "获取会员卡信息")
  @RequestMapping(value = "/getPhoneNumber", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<UserAuthorizationGetPhoneNumberResponseVO> getPhoneNumber(@RequestBody UserAuthorizationGetPhoneNumberRequestVO vo);
  

  
}
