package com.bizvane.wechatfacade.interfaces;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.wechat.name}", path = "${feign.client.wechat.path}/QRCode")
@Api(value = "二维码相关接口", tags = {"二维码相关接口"})
public interface QRCodeServiceFeign {

    @ApiOperation(value = "创建带参数二维码")
    @RequestMapping(value = "/createQRCode", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createQRCode(@RequestBody QRCodeCreateRequestVO vo);

    @ApiOperation(value = "创建带参数包含自定义图片永久二维码")
    @RequestMapping(value = "/createQRCodeContainImg", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createQRCodeContainImg(@RequestBody QRCodeCreateContainImgRequestVO vo);

    @ApiOperation(value = "创建带参数包含自定义图片临时二维码")
    @RequestMapping(value = "/createQRCodeContainImgTemporary", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createQRCodeContainImgTemporary(@RequestBody QRCodeCreateContainImgTemporaryRequestBO vo);

    @ApiOperation(value = "创建自定义url二维码")
    @RequestMapping(value = "/createUrlQRCode", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createUrlQRCode(@RequestBody UrlQRCodeCreateRequestVO vo);

    @ApiOperation(value = "创建自定义url包含自定义图片二维码")
    @RequestMapping(value = "/createUrlQRCodeContainImg", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createUrlQRCodeContainImg(@RequestBody UrlQRCodeCreateContainImgRequestVO vo);

    @ApiOperation(value = "根据小程序appid创建小程序码")
    @RequestMapping(value = "/createUrlMinaQRCode", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createUrlMinaQRCode(@RequestBody UrlMinaQRCodeCreateRequestVO vo);

    @Deprecated
    @ApiOperation(value = "创建小程序自定义页面二维码")
    @RequestMapping(value = "/createMiniprgmQRCode", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createMiniprgmQRCode(@RequestBody CreateMiniprgmQRCodeRequestVO vo);

    @Deprecated
    @ApiOperation(value = "创建小程序自定义页面二维码JPG")
    @RequestMapping(value = "/createMiniprgmQRCodeJPG", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createMiniprgmQRCodeJPG(@RequestBody CreateMiniprgmQRCodeRequestJPGVO vo);

    @ApiOperation(value = "创建小程序小程序码")
    @RequestMapping(value = "/createMiniprgmCode", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createMiniprgmCode(@RequestBody QRCodeCreateMiniprgmCodeParam vo);

    @ApiOperation(value = "创建小程序小程序码-兼容俱乐部")
    @RequestMapping(value = "/createMiniprgmCodeNew", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> createMiniprgmCodeNew(@RequestBody QRCodeCreateMiniprgmCodeParam vo);

    @ApiOperation(value = "查询二维码/小程序码参数")
    @RequestMapping(value = "/queryParam", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> queryParam(@RequestParam("id") Long id);

    @ApiOperation(value = "获取二维码")
    @RequestMapping(value = "/createQRCodeNew", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<QrCoderReturnVo> createQRCodeNew(@RequestBody  @Valid CreateQRCodeRequestVO vo);

    @ApiOperation(value = "获取2023新春活动二维码")
    @RequestMapping(value = "/create23NewYearActivitiesQRUrl", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> create23NewYearActivitiesQRUrl(@RequestBody Create23NewYearActivitiesQRUrlVO vo);


}
