package com.bizvane.wechatfacade.interfaces;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.bizvane.wechatfacade.models.vo.WxPublicVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/wxPublic")
@Api(value="公众号相关接口")
public interface WxPublicServiceFeign{

    /**
     * 根据公众号wxPublicId获取access_token
     * @param publicId
     * @return
     */
    @ApiOperation(value = "根据公众号wxPublicId获取access_token")
    @RequestMapping(value = "/getByWxPublicId",method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> getAccessTokenByPublicId(@RequestParam("wxPublicId")Long wxPublicId);

    /**
     * 根据公众号获取WeUtils
     * @param publicId
     * @return
     */
    @ApiOperation(value = "根据公众号wxPublicId获取access_token")
    @RequestMapping(value = "/getWxPublicPOByPublicId",method = RequestMethod.POST)
    @ResponseBody
    ResponseData<WxPublicPO> getWxPublicPOByPublicId(@RequestParam("publicId")Long publicId);

    /**
     * 根据appid查找token
     * @return
     */
    @ApiOperation(value = "根据appid查找token")
    @RequestMapping(value = "/getAccessTokenByAppId",method = RequestMethod.POST)
    @ResponseBody
    ResponseData<String> getAccessTokenByAppId(@RequestParam("appid")String appid);

    /**
     * 根据公众号wxPublicId获取公众号信息
     * @param wxPublicId
     * @return
     */
    @ApiOperation(value = "根据公众号wxPublicId获取公众号信息")
    @RequestMapping(value = "/selectByWxPublicId",method = RequestMethod.POST)
    @ResponseBody
    ResponseData<WxPublicPO> selectByPrimaryKey(@RequestParam("wxPublicId")Long wxPublicId);

    /**
     * 根据appid获得公众号信息
     * @param appid
     * @return
     */
    @ApiOperation(value = "根据appid获得公众号信息")
    @RequestMapping(value = "/getWxPublicPOByAppId")
    @ResponseBody
    ResponseData<WxPublicPO> getWxPublicPOByAppId(@RequestParam("appid")String appid);
    
    /**
     * 根据品牌id查询公众号和小程序列表
     * @param sysBrandId
     * @return
     */
    @ApiOperation(value = "根据品牌id查询公众号和小程序列表")
    @RequestMapping(value = "/getWxPublicListBySysBrandId")
    @ResponseBody
    ResponseData<List<WxPublicPO>> getWxPublicListBySysBrandId(@RequestParam("sysBrandId")Long sysBrandId);

    /**
     * 根据品牌id查询公众号
     * @param sysBrandId
     * @return
     */
    @ApiOperation(value = "根据品牌id查询公众号和小程序列表")
    @RequestMapping(value = "/getWxPublicBySysBrandId")
    @ResponseBody
    ResponseData<WxPublicPO> getWxPublicBySysBrandId(@RequestParam("sysBrandId")Long sysBrandId);
    
    @ApiOperation(value = "获取已授权个人中心小程序的品牌")
    @RequestMapping(value = "/getAuthPersionMinigmBrandIdList")
    @ResponseBody
    ResponseData<List<Long>> getAuthPersionMinigmBrandIdList(@RequestParam("sysBrandIdList")List<Long> sysBrandIdList);


    @RequestMapping(value = "/getVipDispose")
    @ResponseBody
    ResponseData<Boolean> getVipDispose(WxPublicVO vo);

    /**
     * 获取小程序原始Id
     * @param sysBrandId
     * @param publicType
     * @param programType
     * @return
     */
    @RequestMapping(value = "getOriginidBySysBrandIdAndType")
    @ResponseBody
    ResponseData<String> getOriginidBySysBrandIdAndType(@RequestParam("sysBrandId") Long sysBrandId,@RequestParam("wxPublicType") String wxPublicType,@RequestParam("miniProgramType") String miniProgramType);


    @ApiOperation(value = "根据品牌id查询微商城小程序")
    @RequestMapping(value = "/getMallBySysBrandId")
    ResponseData<WxPublicPO> getMallBySysBrandId(@RequestParam("sysBrandId")Long sysBrandId);

}
