package com.bizvane.wechatfacade.models.vo;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 创建小程序码入参
 * @author 董争光
 */
@Data
public class QRCodeCreateMiniprgmCodeParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull
    @ApiModelProperty(value = "企业id", name = "sysCompanyId", required = true)
    private Long sysCompanyId;

    @NotNull
    @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
    private Long sysBrandId;

    @NotBlank
    @ApiModelProperty(value = "小程序类型：10-个人中心小程序，20-微商城小程序", name = "miniProgramType", required = true)
    private String miniProgramType;

    @NotBlank
    @ApiModelProperty(value = "页面路径：必须是已经发布的小程序存在的页面（否则报错），例如 pages/index/index, 根路径前不要填加 /,不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面", name = "path", required = true, example = "pages/template01/coupon-scancode/main")
    private String path;

    @NotBlank
    @ApiModelProperty(value = "参数：只支持数字，大小写英文以及部分特殊字符：!#$&'()*+,/:;=?@-._~，其它字符请自行编码为合法字符（因不支持%，中文无法使用 urlencode 处理，请使用其他编码方式）", name = "scene", required = true)
    private String param;

    @NotNull
    @ApiModelProperty(value = "过期时间", name = "expiredDate", required = true)
    private Date expiredDate;

    @ApiModelProperty(value = "二维码的宽度，单位 px，最小 280px，最大 1280px", name = "scene")
    private String width;

    @ApiModelProperty(value = "图片url", name = "imgUrl")
    private String imgUrl;

}
