package com.bizvane.wechatfacade.models.vo;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("创建自定义url包含自定义图片二维码")
public class UrlQRCodeCreateContainImgRequestVO implements Serializable {
  
  /**
   * 
   */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "品牌id", name = "sysBrandId", required = true)
  private Long sysBrandId;
  
  @ApiModelProperty(value = "链接地址，包含域名", name = "url", required = true, example = "http://www.baidu.com/coupon.html")
  private String url;
  
  @ApiModelProperty(value = "二维码中心自定义图片url", name = "logoImageUrl", required = true, example = "http://www.image.com/logo")
  private String logoImageUrl;

  @ApiModelProperty(value = "企业编号", name = "companyCode", required = true, example = "")
  private String companyCode;

  @ApiModelProperty(value = "品牌编号", name = "brandCode", required = true, example = "")
  private String brandCode;

  public String getCompanyCode() {
    return companyCode;
  }

  public void setCompanyCode(String companyCode) {
    this.companyCode = companyCode;
  }

  public String getBrandCode() {
    return brandCode;
  }

  public void setBrandCode(String brandCode) {
    this.brandCode = brandCode;
  }

  public Long getSysBrandId() {
    return sysBrandId;
  }

  public void setSysBrandId(Long sysBrandId) {
    this.sysBrandId = sysBrandId;
  }

  public String getLogoImageUrl() {
    return logoImageUrl;
  }

  public void setLogoImageUrl(String logoImageUrl) {
    this.logoImageUrl = logoImageUrl;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }
  
}
