package com.bizvane.wechatfacade.models.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import javax.validation.constraints.NotBlank;

/**
 * @author baofeng@zhidemai.com
 * @createTime 2023-08-08 11:10:05
 * @description: 根据IV解密groupChatId请求对象
 */

@Api(value = "根据IV解密groupChatId请求对象")
@Getter
@Setter
@Builder
@NoArgsConstructor(access = AccessLevel.PUBLIC)
@AllArgsConstructor(access = AccessLevel.PUBLIC)
public class DecryptOpengidRequestVO {

    @NotBlank(message = "code不允许为空")
    @ApiModelProperty(name = "code", value = "code")
    private String code;

    @NotBlank(message = "appId不允许为空")
    @ApiModelProperty(name = "appId", value = "appId")
    private String appId;

    @NotBlank(message = "iv不允许为空")
    @ApiModelProperty(name = "iv", value = "iv")
    private String iv;

    @NotBlank(message = "encryptedData不允许为空")
    @ApiModelProperty(name = "encryptedData", value = "加密数据")
    private String encryptedData;

}